/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import java.util.List;
import net.minecraft.world.World;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;

public class FruitHarvestManager
implements IHarvestManager {
    private List<BlockPosition> _treeBlocks;
    private int _currentBlock;
    private boolean _isDone;
    private HarvestMode _harvestMode;
    private Area _area;

    public FruitHarvestManager(World world, Area area, HarvestMode harvestMode) {
        this.reset(world, area, harvestMode);
    }

    @Override
    public BlockPosition getNextBlock() {
        return this._treeBlocks.get(this._currentBlock);
    }

    @Override
    public void moveNext() {
        ++this._currentBlock;
        if (this._currentBlock >= this._treeBlocks.size()) {
            this._isDone = true;
        }
    }

    @Override
    public void reset(World world, Area area, HarvestMode harvestMode) {
        this._harvestMode = harvestMode;
        this._area = area;
        this._currentBlock = 0;
        this._isDone = false;
        this._treeBlocks = this._harvestMode.isInverted ? this._area.getPositionsTopFirst() : this._area.getPositionsBottomFirst();
    }

    @Override
    public boolean getIsDone() {
        return this._isDone;
    }

    @Override
    public BlockPosition getOrigin() {
        return this._area.getOrigin();
    }
}

