/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.IMobEggHandler;
import powercrystals.minefactoryreloaded.api.IRandomMobProvider;
import powercrystals.minefactoryreloaded.api.ISafariNetHandler;
import powercrystals.minefactoryreloaded.api.RandomMob;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.item.ItemFactory;
import powercrystals.minefactoryreloaded.setup.village.VillageTradeHandler;

public class ItemSafariNet
extends ItemFactory {
    private Icon _iconEmpty;
    private Icon _iconBack;
    private Icon _iconMid;
    private Icon _iconFront;

    public ItemSafariNet(int n) {
        super(n);
        this.field_77777_bU = 1;
        this.func_77637_a(MFRCreativeTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (itemStack.func_77978_p() == null) {
            return;
        }
        if (itemStack.field_77993_c == MineFactoryReloadedCore.safariNetJailerItem.field_77779_bT) {
            list.add(StatCollector.func_74838_a((String)"tip.info.mfr.safarinet.jailer"));
        }
        if (itemStack.func_77978_p().func_74767_n("hide")) {
            list.add(StatCollector.func_74838_a((String)"tip.info.mfr.safarinet.mystery"));
        } else {
            list.add(StatCollector.func_74838_a((String)("entity." + itemStack.func_77978_p().func_74779_i("id") + ".name")));
            Class clazz = (Class)EntityList.field_75625_b.get(itemStack.func_77978_p().func_74779_i("id"));
            if (clazz == null) {
                return;
            }
            for (ISafariNetHandler iSafariNetHandler : MFRRegistry.getSafariNetHandlers()) {
                if (!iSafariNetHandler.validFor().isAssignableFrom(clazz)) continue;
                iSafariNetHandler.addInformation(itemStack, entityPlayer, list, bl);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ItemStack itemStack, int n) {
        if (ItemSafariNet.isEmpty(itemStack)) {
            return this._iconEmpty;
        }
        if (n == 0) {
            return this._iconBack;
        }
        if (n == 1) {
            return this._iconMid;
        }
        if (n == 2) {
            return this._iconFront;
        }
        return null;
    }

    @Override
    public void func_94581_a(IconRegister iconRegister) {
        this._iconEmpty = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".empty");
        this._iconBack = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".back");
        this._iconMid = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".mid");
        this._iconFront = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".front");
        this.field_77791_bV = this._iconEmpty;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int n) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int n) {
        if (itemStack.func_77960_j() == 0 && (itemStack.func_77978_p() == null || itemStack.func_77978_p().func_74767_n("hide"))) {
            return 0xFFFFFF;
        }
        EntityEggInfo entityEggInfo = this.getEgg(itemStack);
        if (entityEggInfo == null) {
            return 0xFFFFFF;
        }
        if (n == 2) {
            return entityEggInfo.field_75611_b;
        }
        if (n == 1) {
            return entityEggInfo.field_75612_c;
        }
        return 0xFFFFFF;
    }

    private EntityEggInfo getEgg(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return null;
        }
        for (IMobEggHandler iMobEggHandler : MFRRegistry.getModMobEggHandlers()) {
            EntityEggInfo entityEggInfo = iMobEggHandler.getEgg(itemStack);
            if (entityEggInfo == null) continue;
            return entityEggInfo;
        }
        return null;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        if (world.field_72995_K) {
            return true;
        }
        if (ItemSafariNet.isEmpty(itemStack)) {
            return true;
        }
        return ItemSafariNet.releaseEntity(itemStack, world, n, n2, n3, n4) != null;
    }

    public static Entity releaseEntity(ItemStack itemStack, World world, int n, int n2, int n3, int n4) {
        Entity entity;
        if (world.field_72995_K) {
            return null;
        }
        int n5 = world.func_72798_a(n, n2, n3);
        n += Facing.field_71586_b[n4];
        n2 += Facing.field_71587_c[n4];
        n3 += Facing.field_71585_d[n4];
        double d = 0.0;
        if (n4 == 1 && Block.field_71973_m[n5] != null && Block.field_71973_m[n5].func_71857_b() == 11) {
            d = 0.5;
        }
        if ((entity = itemStack.func_77960_j() != 0 ? ItemSafariNet.spawnCreature(world, itemStack.func_77960_j(), (double)n + 0.5, (double)n2 + d, (double)n3 + 0.5) : ItemSafariNet.spawnCreature(world, itemStack.func_77978_p(), (double)n + 0.5, (double)n2 + d, (double)n3 + 0.5, n4)) != null) {
            if (entity instanceof EntityLiving && itemStack.field_77993_c == MineFactoryReloadedCore.safariNetJailerItem.field_77779_bT && itemStack.func_82837_s()) {
                ((EntityLiving)entity).func_94058_c(itemStack.func_82833_r());
            }
            if (ItemSafariNet.isSingleUse(itemStack)) {
                --itemStack.field_77994_a;
            } else if (itemStack.func_77960_j() != 0) {
                itemStack.func_77964_b(0);
            } else {
                itemStack.func_77982_d(null);
            }
        }
        return entity;
    }

    private static Entity spawnCreature(World world, NBTTagCompound nBTTagCompound, double d, double d2, double d3, int n) {
        Entity entity;
        NBTTagList nBTTagList;
        if (nBTTagCompound.func_74767_n("hide")) {
            nBTTagList = new ArrayList();
            for (IRandomMobProvider iRandomMobProvider : MFRRegistry.getRandomMobProviders()) {
                System.out.println("Adding mobs from " + iRandomMobProvider.getClass().getName());
                nBTTagList.addAll(iRandomMobProvider.getRandomMobs(world));
            }
            entity = ((RandomMob)WeightedRandom.func_76271_a((Random)world.field_73012_v, (Collection)nBTTagList)).getMob();
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_110161_a(null);
            }
        } else {
            nBTTagList = nBTTagCompound.func_74761_m("Pos");
            ((NBTTagDouble)nBTTagList.func_74743_b((int)0)).field_74755_a = d;
            ((NBTTagDouble)nBTTagList.func_74743_b((int)1)).field_74755_a = d2;
            ((NBTTagDouble)nBTTagList.func_74743_b((int)2)).field_74755_a = d3;
            entity = EntityList.func_75615_a((NBTTagCompound)nBTTagCompound, (World)world);
            if (entity != null) {
                entity.func_70020_e(nBTTagCompound);
            }
        }
        if (entity != null) {
            int n2 = Facing.field_71586_b[n];
            int n3 = n == 0 ? -1 : 0;
            int n4 = Facing.field_71585_d[n];
            AxisAlignedBB axisAlignedBB = entity.field_70121_D;
            entity.func_70012_b(d + (axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) * 0.5 * (double)n2, d2 + (axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b) * 0.5 * (double)n3, d3 + (axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) * 0.5 * (double)n4, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d(entity);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70642_aH();
            }
            Entity entity2 = entity.field_70153_n;
            while (entity2 != null) {
                entity2.func_70012_b(d, d2, d3, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d(entity2);
                if (entity2 instanceof EntityLiving) {
                    ((EntityLiving)entity2).func_70642_aH();
                }
                entity2 = entity2.field_70153_n;
            }
        }
        return entity;
    }

    private static Entity spawnCreature(World world, int n, double d, double d2, double d3) {
        if (!EntityList.field_75627_a.containsKey(n)) {
            return null;
        }
        Entity entity = EntityList.func_75616_a((int)n, (World)world);
        if (entity != null) {
            entity.func_70012_b(d, d2, d3, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_110161_a(null);
            }
            world.func_72838_d(entity);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70642_aH();
            }
        }
        return entity;
    }

    public boolean func_111207_a(ItemStack itemStack, EntityPlayer entityPlayer, EntityLivingBase entityLivingBase) {
        return ItemSafariNet.captureEntity(itemStack, entityLivingBase, entityPlayer);
    }

    public static boolean captureEntity(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return ItemSafariNet.captureEntity(itemStack, entityLivingBase, null);
    }

    public static boolean captureEntity(ItemStack itemStack, EntityLivingBase entityLivingBase, EntityPlayer entityPlayer) {
        if (entityLivingBase.field_70170_p.field_72995_K) {
            return false;
        }
        if (!ItemSafariNet.isEmpty(itemStack)) {
            return false;
        }
        if (MFRRegistry.getSafariNetBlacklist().contains(entityLivingBase.getClass())) {
            return false;
        }
        if (!(entityLivingBase instanceof EntityPlayer)) {
            boolean bl = entityPlayer != null && entityPlayer.field_71075_bZ.field_75098_d;
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            entityLivingBase.func_70109_d(nBTTagCompound);
            nBTTagCompound.func_74778_a("id", (String)EntityList.field_75626_c.get(entityLivingBase.getClass()));
            if (itemStack.field_77993_c == MineFactoryReloadedCore.safariNetJailerItem.field_77779_bT) {
                nBTTagCompound.func_74757_a("PersistenceRequired", true);
            }
            if (!bl) {
                entityLivingBase.func_70106_y();
            }
            if (bl | entityLivingBase.field_70128_L) {
                itemStack.func_77982_d(nBTTagCompound);
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return itemStack == null || itemStack.func_77960_j() == 0 && (itemStack.func_77978_p() == null || !itemStack.func_77978_p().func_74764_b("id") && !itemStack.func_77978_p().func_74767_n("hide"));
    }

    public static boolean isSingleUse(ItemStack itemStack) {
        return itemStack != null && (itemStack.field_77993_c == MineFactoryReloadedCore.safariNetSingleItem.field_77779_bT || itemStack.field_77993_c == MineFactoryReloadedCore.safariNetJailerItem.field_77779_bT);
    }

    public static boolean isSafariNet(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof ItemSafariNet;
    }

    @Override
    public void func_77633_a(int n, CreativeTabs creativeTabs, List list) {
        super.func_77633_a(n, creativeTabs, list);
        if (n == MineFactoryReloadedCore.safariNetSingleItem.field_77779_bT) {
            list.add(VillageTradeHandler.getHiddenNetStack());
        }
    }
}

