/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.core.FruitHarvestManager;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFruitPicker;
import powercrystals.minefactoryreloaded.gui.container.ContainerFruitPicker;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityFruitPicker
extends TileEntityFactoryPowered {
    private IHarvestManager _treeManager;
    private Random _rand;

    public TileEntityFruitPicker() {
        super(Machine.FruitPicker);
        this._areaManager = new HarvestAreaManager(this, 1, 0, 0);
        this._rand = new Random();
        this.setManageSolids(true);
        this.setCanRotate(true);
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        if (!this.field_70331_k.field_72995_K) {
            this._treeManager = new FruitHarvestManager(this.field_70331_k, new Area(new BlockPosition((TileEntity)this), 0, 0, 0), HarvestMode.FruitTree);
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public ContainerFruitPicker getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFruitPicker(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFruitPicker(this.getContainer(inventoryPlayer), this);
    }

    @Override
    protected boolean activateMachine() {
        int n = 0;
        int n2 = 0;
        BlockPosition blockPosition = this.getNextTree();
        if (blockPosition == null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        n2 = this.field_70331_k.func_72805_g(blockPosition.x, blockPosition.y, blockPosition.z);
        IFactoryFruit iFactoryFruit = MFRRegistry.getFruits().get(new Integer(n));
        List<ItemStack> list = iFactoryFruit.getDrops(this.field_70331_k, this._rand, blockPosition.x, blockPosition.y, blockPosition.z);
        ItemStack itemStack = iFactoryFruit.getReplacementBlock(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        iFactoryFruit.prePick(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        this.doDrop(list);
        if (itemStack == null) {
            if (MFRConfig.playSounds.getBoolean(true)) {
                this.field_70331_k.func_72889_a(null, 2001, blockPosition.x, blockPosition.y, blockPosition.z, n + (n2 << 12));
            }
            this.field_70331_k.func_94571_i(blockPosition.x, blockPosition.y, blockPosition.z);
        } else {
            this.field_70331_k.func_72832_d(blockPosition.x, blockPosition.y, blockPosition.z, itemStack.field_77993_c, itemStack.func_77960_j(), 3);
        }
        iFactoryFruit.postPick(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z);
        return true;
    }

    private BlockPosition getNextTree() {
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        Integer n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!MFRRegistry.getFruitLogBlockIds().contains(n)) {
            return null;
        }
        BlockPosition blockPosition2 = this.getNextTreeSegment(blockPosition);
        if (blockPosition2 != null) {
            this._areaManager.rewindBlock();
        }
        return blockPosition2;
    }

    private BlockPosition getNextTreeSegment(BlockPosition blockPosition) {
        Area area;
        if (this._treeManager.getIsDone() || !this._treeManager.getOrigin().equals((Object)blockPosition)) {
            int n = 0;
            int n2 = MFRConfig.fruitTreeSearchMaxVertical.getInt();
            area = new Area(blockPosition.copy(), MFRConfig.fruitTreeSearchMaxHorizontal.getInt(), n, n2);
            this._treeManager.reset(this.field_70331_k, area, HarvestMode.FruitTree);
        }
        Map<Integer, IFactoryFruit> map = MFRRegistry.getFruits();
        while (!this._treeManager.getIsDone()) {
            BlockPosition blockPosition2 = this._treeManager.getNextBlock();
            Integer n = this.field_70331_k.func_72798_a(blockPosition2.x, blockPosition2.y, blockPosition2.z);
            IFactoryFruit iFactoryFruit = area = map.containsKey(n) ? map.get(n) : null;
            if (area != null && area.canBePicked(this.field_70331_k, blockPosition2.x, blockPosition2.y, blockPosition2.z)) {
                return blockPosition2;
            }
            this._treeManager.moveNext();
        }
        return null;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[0]);
    }

    @Override
    public ForgeDirection getDropDirection() {
        return this.getDirectionFacing().getOpposite();
    }
}

