/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import openmods.gui.component.IComponentListener;
import openmods.utils.TextureUtils;

public abstract class BaseComponent
extends Gui {
    public static final ResourceLocation TEXTURE_SHEET = new ResourceLocation("openmodslib", "textures/gui/components.png");
    protected String name = null;
    protected int x;
    protected int y;
    protected boolean renderChildren = true;
    protected boolean enabled = true;
    private boolean hasMouse = false;
    private List<IComponentListener> listeners = new ArrayList<IComponentListener>();
    public List<BaseComponent> components = new ArrayList<BaseComponent>();

    protected void bindComponentsSheet() {
        TextureUtils.bindTextureToClient(TEXTURE_SHEET);
    }

    public BaseComponent(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public String getName() {
        return this.name;
    }

    public BaseComponent setName(String name) {
        this.name = name;
        return this;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean capturingMouse() {
        return this.hasMouse;
    }

    protected boolean isMouseOver(int mouseX, int mouseY) {
        this.hasMouse = mouseX >= this.x && mouseX < this.x + this.getWidth() && mouseY >= this.y && mouseY < this.y + this.getHeight();
        return this.hasMouse;
    }

    public BaseComponent addComponent(BaseComponent component) {
        this.components.add(component);
        return this;
    }

    public BaseComponent childByName(String componentName) {
        if (componentName == null) {
            return null;
        }
        for (BaseComponent component : this.components) {
            if (!componentName.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    public BaseComponent addListener(IComponentListener listener) {
        if (this.listeners.contains(listener)) {
            return this;
        }
        this.listeners.add(listener);
        return this;
    }

    public void removeListener(IComponentListener listener) {
        if (!this.listeners.contains(listener)) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.renderChildren) {
            for (BaseComponent component : this.components) {
                if (component == null || !component.isEnabled()) continue;
                component.render(minecraft, offsetX + this.x, offsetY + this.y, mouseX - this.x, mouseY - this.y);
            }
        }
    }

    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.renderChildren) {
            for (BaseComponent component : this.components) {
                if (component == null || !component.isEnabled()) continue;
                component.renderOverlay(minecraft, offsetX + this.x, offsetY + this.y, mouseX - this.x, mouseY - this.y);
            }
        }
    }

    public void keyTyped(char par1, int par2) {
        this.invokeListenersKeyTyped(par1, par2);
        if (this.renderChildren) {
            for (BaseComponent component : this.components) {
                if (component == null || !component.isEnabled()) continue;
                component.keyTyped(par1, par2);
            }
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        this.invokeListenersMouseDown(mouseX, mouseY, button);
        if (this.renderChildren) {
            for (BaseComponent component : this.components) {
                if (component == null || !component.isEnabled() || !component.isMouseOver(mouseX, mouseY)) continue;
                component.mouseClicked(mouseX - component.x, mouseY - component.y, button);
            }
        }
    }

    public void mouseClickMove(int mouseX, int mouseY, int button, long time) {
        this.invokeListenersMouseDrag(mouseX, mouseY, button, time);
        if (this.renderChildren) {
            for (BaseComponent component : this.components) {
                if (component == null || !component.isEnabled() || !component.isMouseOver(mouseX, mouseY)) continue;
                component.mouseClickMove(mouseX - component.x, mouseY - component.y, button, time);
            }
        }
    }

    public void mouseMovedOrUp(int mouseX, int mouseY, int button) {
        if (button >= 0) {
            this.invokeListenersMouseUp(mouseX, mouseY, button);
        } else {
            this.invokeListenersMouseMove(mouseX, mouseY);
        }
        if (this.renderChildren) {
            for (BaseComponent component : this.components) {
                if (component == null || !component.isEnabled() || !component.isMouseOver(mouseX, mouseY)) continue;
                component.mouseMovedOrUp(mouseX - component.x, mouseY - component.y, button);
            }
        }
    }

    private void invokeListenersMouseDown(int offsetX, int offsetY, int button) {
        if (this.isMouseOver(offsetX + this.x, offsetY + this.y)) {
            for (IComponentListener listener : this.listeners) {
                listener.componentMouseDown(this, offsetX, offsetY, button);
            }
        }
    }

    private void invokeListenersMouseDrag(int offsetX, int offsetY, int button, long time) {
        if (this.isMouseOver(offsetX + this.x, offsetY + this.y)) {
            for (IComponentListener listener : this.listeners) {
                listener.componentMouseDrag(this, offsetX, offsetY, button, time);
            }
        }
    }

    private void invokeListenersMouseMove(int offsetX, int offsetY) {
        if (this.isMouseOver(offsetX + this.x, offsetY + this.y)) {
            for (IComponentListener listener : this.listeners) {
                listener.componentMouseMove(this, offsetX, offsetY);
            }
        }
    }

    private void invokeListenersKeyTyped(char par1, int par2) {
        for (IComponentListener listener : this.listeners) {
            listener.componentKeyTyped(this, par1, par2);
        }
    }

    private void invokeListenersMouseUp(int offsetX, int offsetY, int button) {
        if (this.isMouseOver(offsetX + this.x, offsetY + this.y)) {
            for (IComponentListener listener : this.listeners) {
                listener.componentMouseUp(this, offsetX, offsetY, button);
            }
        }
    }

    public static enum TabColor {
        blue(8881352),
        lightblue(8701896),
        green(8702098),
        yellow(13092996),
        red(13142660),
        purple(13141183);

        private int color;

        private TabColor(int col) {
            this.color = col;
        }

        public int getColor() {
            return this.color;
        }
    }
}

