/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import openmods.gui.component.BaseComponent;
import org.lwjgl.opengl.GL11;

public class GuiComponentItemStackSpinner
extends BaseComponent {
    private ItemStack stack;
    private float rotationY = 0.0f;
    private static ItemRenderer itemRenderer;
    private static RenderBlocks blockRenderer;

    public GuiComponentItemStackSpinner(int x, int y, ItemStack stack) {
        super(x, y);
        if (itemRenderer == null) {
            itemRenderer = new ItemRenderer(Minecraft.func_71410_x());
        }
        this.stack = stack;
    }

    @Override
    public int getWidth() {
        return 64;
    }

    @Override
    public int getHeight() {
        return 64;
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.renderOverlay(minecraft, offsetX, offsetY, mouseX, mouseY);
        GL11.glPushMatrix();
        GL11.glEnable((int)2929);
        float scale = 30.0f;
        GL11.glTranslated((double)((float)(offsetX + this.x) + scale / 2.0f), (double)((float)(offsetY + this.y) + scale / 2.0f), (double)scale);
        GL11.glScaled((double)scale, (double)(-scale), (double)scale);
        this.rotationY += 0.6f;
        GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderItem(this.stack);
        GL11.glDisable((int)2929);
        GL11.glPopMatrix();
    }

    public void renderItem(ItemStack itemStack) {
        IItemRenderer customRenderer;
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        TextureManager texturemanager = mc.func_110434_K();
        Block block = null;
        if (itemStack.func_77973_b() instanceof ItemBlock && itemStack.field_77993_c < Block.field_71973_m.length) {
            block = Block.field_71973_m[itemStack.field_77993_c];
        }
        if ((customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemStack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY)) != null) {
            texturemanager.func_110577_a(texturemanager.func_130087_a(itemStack.func_94608_d()));
            ForgeHooksClient.renderEquippedItem((IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY, (IItemRenderer)customRenderer, (RenderBlocks)blockRenderer, (EntityLivingBase)player, (ItemStack)itemStack);
        } else if (block != null && itemStack.func_94608_d() == 0 && RenderBlocks.func_78597_b((int)Block.field_71973_m[itemStack.field_77993_c].func_71857_b())) {
            texturemanager.func_110577_a(texturemanager.func_130087_a(0));
            blockRenderer.func_78600_a(Block.field_71973_m[itemStack.field_77993_c], itemStack.func_77960_j(), 1.0f);
        } else {
            Icon icon = player.func_70620_b(itemStack, 0);
            if (icon == null) {
                GL11.glPopMatrix();
                return;
            }
            texturemanager.func_110577_a(texturemanager.func_130087_a(itemStack.func_94608_d()));
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    static {
        blockRenderer = new RenderBlocks();
    }
}

