/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import openmods.gui.component.GuiComponentBox;

public class GuiComponentTankLevel
extends GuiComponentBox {
    protected IFluidTank tank;

    public GuiComponentTankLevel(int x, int y, int width, int height, IFluidTank tank) {
        super(x, y, width, height, 0, 0, 0xC6C6C6);
        this.tank = tank;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
        FluidStack stack = this.tank.getFluid();
        double percentFull = Math.max(0.0, Math.min(1.0, (double)this.tank.getFluidAmount() / (double)this.tank.getCapacity()));
        if (stack != null && stack.getFluid() != null) {
            minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            Icon icon = stack.getFluid().getIcon();
            if (icon != null) {
                double fluidHeight = (double)(this.height - 3) * percentFull;
                tessellator.func_78374_a((double)(offsetX + this.x + 3), (double)(offsetY + this.y + this.height - 3), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94210_h());
                tessellator.func_78374_a((double)(offsetX + this.x + this.width - 3), (double)(offsetY + this.y + this.height - 3), (double)this.field_73735_i, (double)icon.func_94212_f(), (double)icon.func_94210_h());
                tessellator.func_78374_a((double)(offsetX + this.x + this.width - 3), (double)(offsetY + this.y) + ((double)this.height - fluidHeight), (double)this.field_73735_i, (double)icon.func_94212_f(), (double)icon.func_94206_g());
                tessellator.func_78374_a((double)(offsetX + this.x + 3), (double)(offsetY + this.y) + ((double)this.height - fluidHeight), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94206_g());
                tessellator.func_78381_a();
            }
        }
    }
}

