/*
 * Decompiled with CFR 0.152.
 */
package openmods.shapes;

import openmods.shapes.IShapeGenerator;
import openmods.shapes.IShapeable;
import openmods.utils.MathUtils;

public class ShapeCylinderGenerator
implements IShapeGenerator {
    @Override
    public void generateShape(int radiusX, int height, int radiusZ, IShapeable shapeable) {
        if (height == 0) {
            return;
        }
        double invRadiusX = 1.0 / (double)radiusX;
        double invRadiusZ = 1.0 / (double)radiusZ;
        double nextXn = 0.0;
        block0: for (int x = 0; x <= radiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextZn = 0.0;
            for (int z = 0; z <= radiusZ; ++z) {
                double zn = nextZn;
                nextZn = (double)(z + 1) * invRadiusZ;
                double distanceSq = MathUtils.lengthSq(xn, zn);
                if (distanceSq > 1.0) {
                    if (z != 0) continue block0;
                    break block0;
                }
                if (MathUtils.lengthSq(nextXn, zn) <= 1.0 && MathUtils.lengthSq(xn, nextZn) <= 1.0) continue;
                for (int y = -height; y <= height; ++y) {
                    shapeable.setBlock(x, y, z);
                    shapeable.setBlock(-x, y, z);
                    shapeable.setBlock(x, y, -z);
                    shapeable.setBlock(-x, y, -z);
                }
            }
        }
    }
}

