/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class SimpleBlockTextureHelper {
    private Icon side_up;
    private Icon side_right;
    private Icon side_down;
    private Icon side_left;
    private Icon top;
    private Icon bottom;
    private Map<ForgeDirection, Icon[]> orientations;

    public Icon setTop(Icon icon) {
        this.top = icon;
        return this.top;
    }

    public Icon setBottom(Icon icon) {
        this.bottom = icon;
        return this.bottom;
    }

    public Icon setSideLeft(Icon icon) {
        this.side_left = icon;
        return this.side_left;
    }

    public Icon setSideUp(Icon icon) {
        this.side_up = icon;
        return this.side_up;
    }

    public Icon setSideRight(Icon icon) {
        this.side_right = icon;
        return this.side_right;
    }

    public Icon setSideDown(Icon icon) {
        this.side_down = icon;
        return this.side_down;
    }

    private void setup() {
        this.orientations = Maps.newEnumMap(ForgeDirection.class);
        this.orientations.put(ForgeDirection.DOWN, new Icon[]{this.top, this.bottom, this.side_down, this.side_down, this.side_down, this.side_down});
        this.orientations.put(ForgeDirection.UP, new Icon[]{this.bottom, this.top, this.side_up, this.side_up, this.side_up, this.side_up});
        this.orientations.put(ForgeDirection.WEST, new Icon[]{this.side_left, this.side_left, this.side_right, this.side_left, this.top, this.bottom});
        this.orientations.put(ForgeDirection.EAST, new Icon[]{this.side_right, this.side_right, this.side_left, this.side_right, this.bottom, this.top});
        this.orientations.put(ForgeDirection.SOUTH, new Icon[]{this.side_down, this.side_down, this.bottom, this.top, this.side_right, this.side_left});
        this.orientations.put(ForgeDirection.NORTH, new Icon[]{this.side_up, this.side_up, this.top, this.bottom, this.side_left, this.side_right});
    }

    public Icon getIconForDirection(ForgeDirection direction, ForgeDirection side) {
        if (this.orientations == null) {
            this.setup();
        }
        return this.orientations.get(direction)[side.ordinal()];
    }
}

