/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tile.TileEntityGenerator;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraftforge.common.ForgeDirection;

public class TileEntitySolarGenerator
extends TileEntityGenerator {
    public boolean seesSun = false;
    public double GENERATION_RATE;

    public TileEntitySolarGenerator() {
        super("SolarGenerator", 96000.0, MekanismGenerators.solarGeneration * 2.0);
        this.GENERATION_RATE = MekanismGenerators.solarGeneration;
        this.inventory = new ItemStack[1];
    }

    public TileEntitySolarGenerator(String name, double maxEnergy, double output, double generation) {
        super(name, maxEnergy, output);
        this.GENERATION_RATE = generation;
        this.inventory = new ItemStack[1];
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public float getVolumeMultiplier() {
        return 0.05f;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ChargeUtils.charge((int)0, (TileEntityElectricBlock)this);
        if (!this.field_70331_k.field_72995_K) {
            this.seesSun = this.field_70331_k.func_72935_r() && (!this.field_70331_k.func_72896_J() && !this.field_70331_k.func_72911_I() || this.isDesert()) && !this.field_70331_k.field_73011_w.field_76576_e && this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
            if (this.canOperate()) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() + this.getProduction());
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean isDesert() {
        return this.field_70331_k.field_73011_w.getBiomeGenForCoords(this.field_70329_l >> 4, this.field_70327_n >> 4) instanceof BiomeGenDesert;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 0) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)true);
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.getEnergy() < this.getMaxEnergy() && this.seesSun && MekanismUtils.canFunction((TileEntity)this);
    }

    public double getProduction() {
        double ret = 0.0;
        if (this.seesSun) {
            ret = this.GENERATION_RATE;
            if (this.field_70331_k.field_73011_w instanceof ISolarLevel) {
                ret *= ((ISolarLevel)this.field_70331_k.field_73011_w).getSolarEnergyMultiplier();
            }
            if (this.isDesert()) {
                ret *= 1.5;
            }
            return ret;
        }
        return 0.0;
    }

    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getSeesSun"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.seesSun};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.seesSun = dataStream.readBoolean();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.seesSun);
        return data;
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        return EnumSet.of(ForgeDirection.getOrientation((int)0));
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }
}

