/**
 * Container class for the statue
 */

package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.utilities.ContainerTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class ContainerShowcase extends ContainerTileEntity<TileEntityShowcase> {
	private final IInventory			inv;
	private final TileEntityShowcase	tile;

	public ContainerShowcase(InventoryPlayer inventory, TileEntityShowcase teshowcase) {
		super(inventory, teshowcase,48,144);
		
		inv = inventory;
		tile = teshowcase;
		
		addSlotToContainer(new SlotHand(teshowcase, 0, 120, 59));

		tile.openChest();
	}

	@Override
	public void onContainerClosed(EntityPlayer par1EntityPlayer) {
		super.onContainerClosed(par1EntityPlayer);

		tile.closeChest();
	}
}
