package info.jbcs.minecraft.statues;


import info.jbcs.minecraft.utilities.DummyContainer;
import info.jbcs.minecraft.utilities.General;
import info.jbcs.minecraft.utilities.GuiHandler;
import info.jbcs.minecraft.utilities.packets.PacketHandler;

import java.io.File;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "Statues", name = "Statues", version = "2.1.1", dependencies = "required-after:Autoutils")
@NetworkMod(clientSideRequired = true, serverSideRequired = true)
public class Statues{
	static Configuration				config;

	@Instance("Statues")
	public static Statues instance;

	@SidedProxy(clientSide = "info.jbcs.minecraft.statues.ProxyClient", serverSide = "info.jbcs.minecraft.statues.Proxy")
	public static Proxy proxy;

	public static Block			statue;
	public static Block			showcase;
	public static Item			hammer;
	public static Item			itemPalette;
	public static Item			itemStatue;
	public static Item			itemShowcase;

	public static Icon			slotHand;
	
	public static GuiHandler	guiShowcase;
	public static GuiHandler	guiStatue;
	public static GuiHandler	guiSculpt;

	public static boolean		debugImages;

	@PreInit
	public void preInit(FMLPreInitializationEvent event) {
		File configFile=event.getSuggestedConfigurationFile();
		config = new Configuration(configFile);
		config.load();
		
		proxy.preInit();
 	}
	
	int getBlock(String name,int id){
		return config.getBlock(name, id).getInt(id);
	}
	
	int getItem(String name,int id){
		return config.getItem(name, id).getInt(id);
	}
	@Init
	public void init(FMLInitializationEvent event) {
		debugImages = config.get("general", "debug skins", false, "Save generated skins to files.").getBoolean(false);

		statue				= new BlockStatue(getBlock("statue",1500), Material.rock).setHardness(1F).setResistance(1F).setUnlocalizedName("statue").setStepSound(Block.soundStoneFootstep);
		showcase			= new BlockShowcase(getBlock("showcase",1501), Material.wood).setHardness(1F).setResistance(1F).setUnlocalizedName("showcase").setStepSound(Block.soundWoodFootstep);
		hammer				= new ItemMarteau(getItem("marteau",5002)).setTextureName("statues:marteau").setUnlocalizedName("marteau");
		itemShowcase		= new ItemShowcase(getItem("itemshowcase",5004), showcase).setTextureName("statues:itemshowcase").setUnlocalizedName("itemshowcase");
		itemPalette			= new ItemPalette(getItem("palette",5003)).setTextureName("statues:palette").setUnlocalizedName("palette");
		
		LanguageRegistry.addName(statue, "Statue");
		LanguageRegistry.addName(showcase, "Showcase");
		LanguageRegistry.addName(itemShowcase, "Showcase");
		
		LanguageRegistry.addName(hammer, "Hammer");
		LanguageRegistry.addName(itemPalette, "Palette");
		
        GameRegistry.registerTileEntity(TileEntityStatue.class, "TileEntityStatue");
        GameRegistry.registerTileEntity(TileEntityShowcase.class, "TileEntityShowcase");
        
		ModLoader.addRecipe(new ItemStack(hammer, 1), new Object[] { " I ", " SI", "S  ", Character.valueOf('S'), Item.stick, Character.valueOf('I'), Item.ingotIron });
		ModLoader.addRecipe(new ItemStack(itemShowcase, 1), new Object[] { "GGG", "W W", "S S", Character.valueOf('S'), Item.stick, Character.valueOf('W'), Block.wood, Character.valueOf('G'), Block.thinGlass});
		ModLoader.addRecipe(new ItemStack(itemPalette, 1), new Object[] { "GB", "RW",
			Character.valueOf('W'), Block.planks,
			Character.valueOf('R'), new ItemStack(Item.dyePowder,1,1),
			Character.valueOf('G'), new ItemStack(Item.dyePowder,1,2),
			Character.valueOf('B'), new ItemStack(Item.dyePowder,1,4),
		});

		MinecraftForge.setBlockHarvestLevel(showcase, "axe", 0);

        guiShowcase=new GuiHandler("showcase"){
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		        TileEntity tileEntity = world.getBlockTileEntity(x, y, z);

		        if(! (tileEntity instanceof TileEntityShowcase))
		        	return null;
		        
		        TileEntityShowcase e=(TileEntityShowcase) tileEntity;
		        
		        return new ContainerShowcase(player.inventory, e);
			}

			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.getBlockTileEntity(x, y, z);

		        if(! (tileEntity instanceof TileEntityShowcase))
		        	return null;
		        
		        TileEntityShowcase e=(TileEntityShowcase) tileEntity;

                return new GuiShowcase(player.inventory,e,world,x,y,z);
			}
		};
        
        guiStatue=new GuiHandler("statue"){
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		        TileEntity tileEntity = world.getBlockTileEntity(x, y, z);

		        if(! (tileEntity instanceof TileEntityStatue))
		        	return null;
		        
		        TileEntityStatue e=(TileEntityStatue) tileEntity;
		        
		        return new ContainerStatue(player.inventory, e);
			}

			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.getBlockTileEntity(x, y, z);

		        if(! (tileEntity instanceof TileEntityStatue))
		        	return null;
		        
		        TileEntityStatue e=(TileEntityStatue) tileEntity;

                return new GuiStatue(player.inventory,e,world,x,y,z);
			}
		};
		
		guiSculpt=new GuiHandler("sculpt"){
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		        return new DummyContainer();
			}

			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				int face = MathHelper.floor_double((player.rotationYaw * 4F) / 360F + 0.5D) & 3;

                return new GuiSculpt(world,x,y,z,player,face);
			}
		};

		GuiHandler.register(this);
        
		Packets.sculpt.create();
		Packets.sculpted.create();
		Packets.adjustStatue.create();
		PacketHandler.register(this);
		
        proxy.init();
        
        config.save();
	}

	public static boolean canSculpt(int id,World world,int x,int y,int z) {
		Block block=General.getBlock(id);
		if(block==null) return false;
		if(block.blockID==Block.bedrock.blockID) return false;
		if(block.blockMaterial==Material.circuits) return false;
		if(block.blockMaterial==Material.fire) return false;
		if(block.blockMaterial==Material.lava) return false;
		if(block.blockMaterial==Material.water) return false;
		if(world.getBlockTileEntity(x, y, z)!=null) return false;
		
		return true;
	}
}