<?php
/**
 * [PHPFOX_HEADER]
 */

defined('PHPFOX') or exit('NO DICE!');

/**
 * 
 * 
 * @copyright		[PHPFOX_COPYRIGHT]
 * @author  		Raymond_Benc
 * @package 		Phpfox_Service
 * @version 		$Id: type.class.php 2818 2011-08-09 12:01:57Z Raymond_Benc $
 */
abstract  class Phpfox_Pages_Type extends Phpfox_Service
{
	/**
	 * Class constructor
	 */	
	public function __construct()
	{	
		$this->_sTable = Phpfox::getT('pages_type');
	}

	/**
	 * @return Phpfox_Pages_Facade
	 */
	abstract public function getFacade();
	public function getById($iId)
	{
		static $aRows = array();
		
		if (isset($aRows[$iId]))
		{
			return $aRows[$iId];
		}
		
		$aRows[$iId] = $this->database()->select('*')
			->from(Phpfox::getT('pages_type'))
			->where('type_id = ' . (int) $iId)
			->execute('getSlaveRow');
		
		if (!isset($aRows[$iId]['type_id']))
		{
			return false;
		}
		
		return $aRows[$iId];
	}
	
	public function get()
	{
		$sCacheId = $this->cache()->set($this->getFacade()->getItemType() . '_types');
		
		if (!($aRows = $this->cache()->get($sCacheId)) || true)
		{
			$aRows = $this->database()->select('*')
				->from($this->_sTable)
				->where('is_active = 1 AND item_type = ' . $this->getFacade()->getItemTypeId())
				->order('ordering ASC')
				->execute('getSlaveRows');

			foreach ($aRows as $iKey => $aRow)
			{
				$aRows[$iKey]['categories'] = $this->getFacade()->getCategory()->getByTypeId($aRow['type_id']);
			}

			$this->cache()->save($sCacheId, $aRows);
		}

		return $aRows;
	}
	
	public function getForEdit($iId)
	{
		$aRow = $this->database()->select('*')
			->from(Phpfox::getT('pages_type'))
			->where('type_id = ' . (int) $iId)
			->execute('getSlaveRow');
        //Support legacy phrases
        if (substr($aRow['name'], 0, 7) == '{phrase' && substr($aRow['name'], -1) == '}') {
            $aRow['name'] = preg_replace('/\s+/', ' ', $aRow['name']);
            $aRow['name'] = str_replace([
                "{phrase var='",
                "{phrase var=\"",
                "'}",
                "\"}"
            ], "", $aRow['name']);
        }//End support legacy
        $aLanguages = Language_Service_Language::instance()->getAll();
        foreach ($aLanguages as $aLanguage){
            $sPhraseValue = (Core\Lib::phrase()->isPhrase($aRow['name'])) ? _p($aRow['name'], [], $aLanguage['language_id']) : $aRow['name'];
            $aRow['name_' . $aLanguage['language_id']] = $sPhraseValue;
        }
		if (!isset($aRow['type_id']))
		{
			return false;
		}
		
		return $aRow;
	}
	
	public function getForAdmin($bGetSub = true)
	{
		$aRows = $this->database()->select('*')
			->from($this->_sTable)
			->where('item_type = ' . $this->getFacade()->getItemTypeId())
			->order('ordering ASC')
			->execute('getSlaveRows');
        foreach ($aRows as $iKey => $aRow){
            if ($bGetSub) {
                $aRows[$iKey]['categories'] = $this->getFacade()->getCategory()->getForAdmin($aRow['type_id']);
            }
        }
		return $aRows;
	}	
	
	/**
	 * If a call is made to an unknown method attempt to connect
	 * it to a specific plug-in with the same name thus allowing 
	 * plug-in developers the ability to extend classes.
	 *
	 * @param string $sMethod is the name of the method
	 * @param array $aArguments is the array of arguments of being passed
	 * @return mixed
	 */
	public function __call($sMethod, $aArguments)
	{
		/**
		 * Check if such a plug-in exists and if it does call it.
		 */
		if ($sPlugin = Phpfox_Plugin::get($this->getFacade()->getItemType() . '.service_type_type__call'))
		{
			eval($sPlugin);
			return null;
		}
			
		/**
		 * No method or plug-in found we must throw a error.
		 */
		Phpfox_Error::trigger('Call to undefined method ' . __CLASS__ . '::' . $sMethod . '()', E_USER_ERROR);
	}	
}