<?php
/**
 * [PHPFOX_HEADER]
 */

defined('PHPFOX') or exit('NO DICE!');

/**
 * 
 * 
 * @copyright		[PHPFOX_COPYRIGHT]
 * @author  		Raymond Benc
 * @package 		Phpfox_Service
 * @version 		$Id: genre.class.php 2556 2011-04-21 20:02:54Z Raymond_Benc $
 */
class Music_Service_Genre_Genre extends Phpfox_Service 
{
	/**
	 * Class constructor
	 */	
	public function __construct()
	{	
		$this->_sTable = Phpfox::getT('music_genre');	
	}

    public function getForEdit($iGenreId){
        $sCacheId = $this->cache()->set('music_genre_edit_' . (int) $iGenreId);
        if (!$aGenre = $this->cache()->get($sCacheId)){
            $aGenre = $this->database()->select('*')
                ->from($this->_sTable)
                ->where('genre_id=' . (int) $iGenreId)
                ->execute('getSlaveRow');
            $aLanguages = Language_Service_Language::instance()->getAll();
            foreach ($aLanguages as $aLanguage) {
                $aGenre['name_' . $aLanguage['language_id']] = Phpfox::getSoftPhrase($aGenre['name'], [], false, null, $aLanguage['language_id']);
            }
            $this->cache()->save($sCacheId, $aGenre);
        }
        return $aGenre;
    }

    public function getForManage()
    {
        $iLangId = Phpfox::getLanguageId();
        
        $sCacheId = $this->cache()->set('music_genre_manage_' . $iLangId);
        if (!$aGenres = $this->cache()->get($sCacheId)){
            $aGenres = $this->database()->select('mc.*')
                ->from($this->_sTable, 'mc')
                ->where('true')
                ->order('mc.ordering ASC')
                ->group('mc.genre_id')
                ->execute('getSlaveRows');
            //Get number items used
            foreach ($aGenres as $iKey => $aGenre) {
                $iTotalUsed = $this->database()->select('count(*)')
                    ->from(':music_song')
                    ->where('genre_id=' . (int) $aGenre['genre_id'])
                    ->execute('getSlaveField');
                $aGenres[$iKey]['used'] = $iTotalUsed;
                $aGenres[$iKey]['link'] = Phpfox::permalink('music.category', $aGenre['genre_id'], Phpfox::getSoftPhrase($aGenre['name']));
            }
            $this->cache()->save($sCacheId, $aGenres);
        }
        return $aGenres;
    }
    
    /**
     * Get all genre for "Genre block" list And when upload a song
     *
     * @return array
     */
	public function getList()
	{		
		$sCacheId = $this->cache()->set('music_genre');
		
		if (!($aRows = $this->cache()->get($sCacheId)))
		{		
			$aRows = $this->database()->select('genre_id, name')
				->from($this->_sTable)
				->order('ordering ASC')
                ->where('is_active=1')
				->execute('getSlaveRows');
				
			$this->cache()->save($sCacheId, $aRows);
		}
		
		foreach ($aRows as $iKey => $aRow)
		{
			if (($sView = Phpfox_Request::instance()->get('view')))
			{
				$aRows[$iKey]['link'] = Phpfox::permalink('music.genre', $aRow['genre_id'], Phpfox::getSoftPhrase($aRow['name']), false, null, array('view' => $sView));
			}
			else 
			{
				$aRows[$iKey]['link'] = Phpfox::permalink('music.genre', $aRow['genre_id'], Phpfox::getSoftPhrase($aRow['name']));
			}			
		}		
			
		return $aRows;
	}
    
    /**
     * @deprecated
     * @param $iUserId
     */
	public function getUserGenre($iUserId)
	{
		
	}
	
	public function getGenre($iGenreId)
	{
		$aRow = $this->database()->select('*')
			->from($this->_sTable)
			->where('genre_id = ' . (int) $iGenreId)
			->execute('getSlaveRow');
			
		return (isset($aRow['genre_id']) ? $aRow : false);
	}
    
	/**
	 * If a call is made to an unknown method attempt to connect
	 * it to a specific plug-in with the same name thus allowing 
	 * plug-in developers the ability to extend classes.
	 *
	 * @param string $sMethod is the name of the method
	 * @param array $aArguments is the array of arguments of being passed
	 * @return null
	 */
	public function __call($sMethod, $aArguments)
	{
		/**
		 * Check if such a plug-in exists and if it does call it.
		 */
		if ($sPlugin = Phpfox_Plugin::get('music.service_genre_genre__call'))
		{
			eval($sPlugin);
            return null;
		}
			
		/**
		 * No method or plug-in found we must throw a error.
		 */
		Phpfox_Error::trigger('Call to undefined method ' . __CLASS__ . '::' . $sMethod . '()', E_USER_ERROR);
	}	
}