<?php
/**
 * [PHPFOX_HEADER]
 */

defined('PHPFOX') or exit('NO DICE!');
define('PHPFOX_IS_PAGES_ADD', true);
/**
 * 
 * 
 * @copyright		[PHPFOX_COPYRIGHT]
 * @author  		Raymond_Benc
 * @package 		Phpfox_Component
 * @version 		$Id: add.class.php 7101 2014-02-11 13:47:16Z Fern $
 */
class Pages_Component_Controller_Add extends Phpfox_Component
{
	/**
	 * Controller
	 */
	public function process()
	{
		Phpfox::isUser(true);
		Phpfox::getUserParam('pages.can_add_new_pages', true);
		
		Pages_Service_Pages::instance()->setIsInPage();
		
		$bIsEdit = false;
		$bIsNewPage = false;
		$sStep = $this->request()->get('req3');
		$aPage = array();
		if (($iEditId = $this->request()->getInt('id')) && ($aPage = Pages_Service_Pages::instance()->getForEdit($iEditId)))
		{
			$bIsEdit = true;
			$this->template()->assign('aForms', $aPage);
            
            $aMenus = [
                'detail' => _p('details'),
                'info'   => _p('info')
            ];
            
            $aMenus['photo'] = _p('photo');
			$aMenus['permissions'] = _p('permissions');
			if (Phpfox::isModule('friend') && Phpfox::getUserBy('profile_page_id') == 0) {
				$aMenus['invite'] = _p('invite');
			}			
			if (!$bIsNewPage) {
				$aMenus['url'] = _p('url');
				$aMenus['admins'] = _p('admins');
				$aMenus['widget'] = _p('widgets');
			}
			
			if (Phpfox::getParam('core.google_api_key')) {
			    $aMenus['location'] = _p('location');
			}
			
			if ($bIsNewPage) {
				$iCnt = 0;
				foreach ($aMenus as $sMenuName => $sMenuValue) {
					$iCnt++;
					$aMenus[$sMenuName] = _p('step_count', array('count' => $iCnt)) . ': ' . $sMenuValue;
				}
			}
			
			
			$this->template()->buildPageMenu('js_pages_block', 
				$aMenus,
				array(
					'link' => Pages_Service_Pages::instance()->getUrl($aPage['page_id'], $aPage['title'], $aPage['vanity_url']),
					'phrase' => ($bIsNewPage ? _p('skip_view_this_page') : _p('view_this_page'))
				)				
			);					
			
			if (($aVals = $this->request()->getArray('val')))
			{
				if (Pages_Service_Process::instance()->update($aPage['page_id'], $aVals, $aPage))
				{
					if ($bIsNewPage && $this->request()->getInt('action') == '1')
					{
						switch ($sStep)
						{
							case 'invite':
								if (Phpfox::isModule('friend'))
								{
									$this->url()->send('pages.add.url', array('id' => $aPage['page_id'], 'new' => '1'));
								}
								break;							
							case 'permissions':
								$this->url()->send('pages.add.invite', array('id' => $aPage['page_id'], 'new' => '1'));
								break;									
							case 'photo':
								$this->url()->send('pages.add.permissions', array('id' => $aPage['page_id'], 'new' => '1'));
								break;						
							case 'info':
								$this->url()->send('pages.add.photo', array('id' => $aPage['page_id'], 'new' => '1'));
								break;
							default:
								$this->url()->send('pages.add.info', array('id' => $aPage['page_id'], 'new' => '1'));
								break;
						}
					}
					
					$aNewPage = Pages_Service_Pages::instance()->getForEdit($aPage['page_id']);
					
					$this->url()->forward(Pages_Service_Pages::instance()->getUrl($aNewPage['page_id'], $aNewPage['title'], $aNewPage['vanity_url']));
				}
			}
		}
		
		if (Phpfox::getParam('core.google_api_key') != '' && $this->request()->get('id') != '')
		{
			$this->template()->setHeader(array(
				'<script type="text/javascript">oParams["core.google_api_key"] = "'.Phpfox::getParam('core.google_api_key') .'";</script>',
				'places.js' => 'module_pages',				
			));

			if (isset($aPage['location']) && ( (int)$aPage['location_latitude'] != 0 || (int)$aPage['location_longitude'] != 0))
			{
				$this->template()->setHeader(array(
					'<script type="text/javascript">$Behavior.setLocation = function(){ $Core.PagesLocation.setLocation("'. $aPage['location_latitude'] .'","' . $aPage['location_longitude'] .'","'. $aPage['location']['name'] . '");};</script>'
				));
			}
		}
		$this->template()->setTitle(($bIsEdit ? '' . _p('editing_page') . ': ' . $aPage['title'] : _p('creating_a_page')))
			->setBreadCrumb(_p('pages'), $this->url()->makeUrl('pages'))
			->setBreadCrumb(($bIsEdit ? '' . _p('editing_page') . ': ' . $aPage['title']: _p('creating_a_page')), $this->url()->makeUrl('pages.add', ['id' => $iEditId]), true)
            ->setPhrase([
                    'select_a_file_to_upload'
                ])->setHeader([
                    'privacy.css' => 'module_user',
                    'progress.js' => 'static_script',
                    'pages.js'    => 'module_pages'
                ])
            ->setHeader(array('<script type="text/javascript">$Behavior.pagesProgressBarSettings = function(){ if ($Core.exists(\'#js_pages_block_customize_holder\')) { oProgressBar = {holder: \'#js_pages_block_customize_holder\', progress_id: \'#js_progress_bar\', uploader: \'#js_progress_uploader\', add_more: false, max_upload: 1, total: 1, frame_id: \'js_upload_frame\', file_id: \'image\'}; $Core.progressBarInit(); } }</script>'))
			->assign(array(
					'aPermissions' => (isset($aPage) && isset($aPage['page_id']) ? Pages_Service_Pages::instance()->getPerms($aPage['page_id']) : array()),
					'aTypes' => Pages_Service_Type_Type::instance()->get(),
					'bIsEdit' => $bIsEdit,
					'iMaxFileSize' => Phpfox::getLib('phpfox.file')->filesize((Phpfox::getUserParam('pages.max_upload_size_pages') / 1024) * 1048576),
					'aWidgetEdits' => Pages_Service_Pages::instance()->getWidgetsForEdit(),
					'bIsNewPage' => $bIsNewPage,
					'sStep' => $sStep
				)
			);
        $this->template()->setHeader([
            'jquery.cropit.js' => 'module_user',
        ]);
	}
	
	/**
	 * Garbage collector. Is executed after this class has completed
	 * its job and the template has also been displayed.
	 */
	public function clean()
	{
		(($sPlugin = Phpfox_Plugin::get('pages.component_controller_add_clean')) ? eval($sPlugin) : false);
	}
}
