<?php
/**
 * [PHPFOX_HEADER]
 */

defined('PHPFOX') or exit('NO DICE!');

/**
 * 
 * 
 * @copyright		[PHPFOX_COPYRIGHT]
 * @author  		Raymond Benc
 * @package 		Phpfox_Component
 * @version 		$Id: profile.class.php 5491 2013-03-12 08:12:07Z Miguel_Espinoza $
 */
class User_Component_Controller_Profile extends Phpfox_Component
{
	/**
	 * Controller
	 */
	public function process()
	{
		Phpfox::isUser(true);
		$bIsEdit = false;
		
		$iUserId = Phpfox::getUserId();
		$iUserGroupId = Phpfox::getUserBy('user_group_id');
		if (($iId = $this->request()->getInt('id')) && Phpfox::getUserParam('custom.can_edit_other_custom_fields') && $iId != Phpfox::getUserId())
		{
			if (($aUser = User_Service_User::instance()->getUser($iId, 'u.user_id, u.user_name, u.full_name')) && isset($aUser['user_id']))
			{
				$iUserId = $aUser['user_id'];
				$iUserGroupId = $aUser['user_group_id'];
				$this->template()->assign('iUserId', $iUserId);
				$bIsEdit = true;
										
				if ($aVals = $this->request()->getArray('custom'))
				{
					if (Custom_Service_Process::instance()->updateFields($iUserId, $iUserId, $aVals))
					{
						$this->url()->send($aUser['user_name'], null, _p('successfully_updated_full_name_profile', array('full_name' => $aUser['full_name'])));
					}
				}
			}
		}
		else 
		{
			Phpfox::getUserParam('custom.can_edit_own_custom_field', true);
		}		
		
		$aCustomGroups = Custom_Service_Group_Group::instance()->getGroups('user_profile', $iUserGroupId);
		$aCustomFields = Custom_Service_Custom::instance()->getForEdit(array('user_main', 'user_panel', 'profile_panel'), $iUserId, $iUserGroupId, false, Phpfox::getUserId());
        
		$aGroupCache = array();
		foreach ($aCustomFields as $aFields)
		{			
			$aGroupCache[$aFields['group_id']] = true;
		}	
        
		if ($sPlugin = Phpfox_Plugin::get('user.component_controller_profile__1')){eval($sPlugin);if (isset($aPluginReturn)){return $aPluginReturn;}}
		foreach ($aCustomGroups as $iKey => $aCustomGroup)
		{
            if ($sPlugin = Phpfox_Plugin::get('user.component_controller_profile__2')){eval($sPlugin);if (isset($aPluginReturn)){return $aPluginReturn;}}
			if (!isset($aGroupCache[$aCustomGroup['group_id']]))
			{
				unset($aCustomGroups[$iKey]);
			}
		}
		
		$aRebuildKeys = $aCustomGroups;
		$aCustomGroups = array();
		$iCnt = 0;
		foreach ($aRebuildKeys as $aCustomGroup)
		{
			$aCustomGroups[$iCnt] = $aCustomGroup;
			$iCnt++;
		}		
		
		
		$aTimeZones = Core_Service_Core::instance()->getTimeZones();
		if (count($aTimeZones) > 100) // we are using the php 5.3 way
		{
			$this->template()->setHeader('cache', array('setting.js' => 'module_user'))
				->setHeader('cache', array(
					'<script type="text/javascript">sSetTimeZone = "' . Phpfox::getUserBy('time_zone') . '";</script>'
				)
			);
		}
		$aForms = User_Service_User::instance()->get(Phpfox::getUserId(), true);
		/* we could put this part inside get but I fear its being wrongly used */
		$aRelation = Custom_Service_Relation_Relation::instance()->getLatestForUser(Phpfox::getUserId(), null, true);
		if (isset($aRelation['status_id']))
		{
			$aForms = array_merge($aForms, $aRelation);					
		}
		
		$sJsArray = '{';
		$aRelations = Custom_Service_Relation_Relation::instance()->getAll();
		foreach ($aRelations as $aItem)
		{
			if ($aItem['confirmation'] == 1)
			{
				$sJsArray .= $aItem['relation_id'] . ':' . $aItem['confirmation'] .',';
			}
		}
		$sJsArray = rtrim($sJsArray, ',') .'}';
		
		$aForms['month'] = substr($aForms['birthday'], 0, 2);
		$aForms['day'] = substr($aForms['birthday'],2,2);
		$aForms['year'] = substr($aForms['birthday'],4);

		if (Phpfox::isModule('friend'))
		{
            $this->template()->setPhrase(['show_more_results_for_search_term']);
        }
        
        if ($sPlugin = Phpfox_Plugin::get('user.component_controller_profile__3')){eval($sPlugin);if (isset($aPluginReturn)){return $aPluginReturn;}}
        
		$this->template()->setTitle(_p('edit_profile'))
			->setBreadCrumb(_p('edit_profile'))
			->setFullSite()
			->setHeader(array(
					'country.js' => 'module_core',
					'custom.js' => 'module_custom',
					'search.js' => 'module_friend',
					'edit-profile.css' => 'module_user'
				)
			)			
		 	->assign(array(
		 			'aGroups' => $aCustomGroups,
		 			'aSettings' => $aCustomFields,
		 			'bIsEdit' => $bIsEdit,
					'sDobStart' => Phpfox::getParam('user.date_of_birth_start'),
					'sDobEnd' => Phpfox::getParam('user.date_of_birth_end'),
					'aTimeZones' => $aTimeZones,
					'aForms' => $aForms,
					'sJsArray' => $sJsArray,
					'aRelations' => Custom_Service_Custom::instance()->getRelations()
		 		)
		 	);
	}
	
	/**
	 * Garbage collector. Is executed after this class has completed
	 * its job and the template has also been displayed.
	 */
	public function clean()
	{
		(($sPlugin = Phpfox_Plugin::get('user.component_controller_profile_clean')) ? eval($sPlugin) : false);
	}
}