/*! jQuery Mosaic Flow v0.2.5 by Artem Sapegin - http://sapegin.github.io/jquery.mosaicflow/ - Licensed MIT */

!function (t) {
    "function" == typeof define && define.amd ? define(["jquery"], t) : t(jQuery)
}(function (t) {
    "use strict";
    function i(t, i) {
        this.container = t, this.options = i, this.container.trigger("start"), this.init(), this.container.trigger("ready")
    }

    function s(t) {
        function i(t, i) {
            return i.toUpper()
        }

        var s = {}, e = t.data();
        for (var n in e)s[n.replace(/-(\w)/g, i)] = e[n];
        return s
    }

    var e = 0;
    t.fn.mosaicflow = function (e) {
        var n = Array.prototype.slice.call(arguments, 0);
        return this.each(function () {
            var o = t(this), r = o.data("mosaicflow");
            r ? "string" == typeof e && r[e](n[1]) : (e = t.extend({}, t.fn.mosaicflow.defaults, e, s(o)), r = new i(o, e), o.data("mosaicflow", r))
        })
    }, t.fn.mosaicflow.defaults = {
        itemSelector: "> .photos_row, > .block",
        columnClass: "mosaicflow__column",
        minItemWidth: 240,
        itemHeightCalculation: "auto",
        threshold: 40
    }, i.prototype = {
        init: function () {
            this.__uid = e++,
                this.__uidItemCounter = 0,
                this.items = this.container.find(this.options.itemSelector),
                this.columns = t([]),
                this.columnsHeights = [],
                this.itemsHeights = {},
                this.is_rebuild = this.container.hasClass('built_flow'),
                this.tempContainer = this.is_rebuild ? $('#temp_container', this.container) : t("<div>", {id: 'temp_container'}).css({
                    visibility: "hidden",
                    width: "100%"
                }),
                this.workOnTemp = !1,
                this.autoCalculation = "auto" === this.options.itemHeightCalculation;

            if (!this.is_rebuild) {
                this.container.append(this.tempContainer)
            }
            var i = this;
            this.items.each(function () {
                var s = t(this), e = s.attr("id");
                e || (e = i.generateUniqueId(), s.attr("id", e))
            }),
                this.container.css("visibility", "hidden"), this.autoCalculation ? t(window).load(t.proxy(this.refill, this)) : this.refill(), this.refill()
        },
        refill: function () {
            this.container.trigger("fill"), this.numberOfColumns = Math.floor(this.container.width() / this.options.minItemWidth), this.numberOfColumns < 1 && (this.numberOfColumns = 1);
            var t = this.ensureColumns();
            t && (this.fillColumns(), this.columns.filter(":hidden").remove()), this.container.css("visibility", "visible"),
                this.container.trigger("filled")

        },
        ensureColumns: function () {
            var i = this.columns.length,
                s = this.numberOfColumns;


                if (this.workingContainer = 0 === i ? this.tempContainer : this.container, s > i) {
                    if (this.is_rebuild) {
                        this.workingContainer = this.tempContainer;
                    }else {
                        for (var e = s - i, n = 0; e > n; n++) {
                            var o = t("<div>", {"class": this.options.columnClass});
                            this.workingContainer.append(o)
                        }
                    }
                }
                else
                    if (i > s) {
                        for (var r = i; r >= s;)this.columns.eq(r).hide(), r--;
                        var h = i - s;
                        this.columnsHeights.splice(this.columnsHeights.length - h, h)
                    }

            if(this.is_rebuild){
                this.columns =  $('.mosaicflow__column',this.container);

                this.numberOfColumns =  this.columns.length;
                var heights = [];
                this.columns.each(function(){
                    heights.push($(this).height());
                });
                this.columnsHeights =  heights;

                // console.log(this.columnsHeights);

                this.recomputeHeights();
                // console.log(this.numberOfColumns );

                return true;
            }



            return s !== i ? (this.columns = this.workingContainer.find("." + this.options.columnClass), this.columns.css("width", 100 / s + "%"), !0) : !1

        }, fillColumns: function () {
            for (var t = this.numberOfColumns, i = this.items.length, s = 0; t > s; s++) {
                var e = this.columns.eq(s);
                this.columnsHeights[s] = 0;
                for (var n = s; i > n; n += t) {
                    var o = this.items.eq(n), r = 0;
                    e.append(o), r = this.autoCalculation ? o.outerHeight() : parseInt(o.find("img").attr("height"), 10), this.itemsHeights[o.attr("id")] = r, this.columnsHeights[s] += r
                }
            }
            this.levelBottomEdge(this.itemsHeights, this.columnsHeights), this.workingContainer === this.tempContainer && this.container.append(this.tempContainer.children()), this.container.trigger("mosaicflow-layout")
        }, levelBottomEdge: function (i, s) {
            for (; ;) {
                var e = t.inArray(Math.min.apply(null, s), s), n = t.inArray(Math.max.apply(null, s), s);
                if (e === n)return;
                var o = this.columns.eq(n).children().last(), r = i[o.attr("id")], h = s[e], a = s[n], l = h + r;
                if (l >= a)return;
                if (a - l < this.options.threshold)return;
                this.columns.eq(e).append(o), s[n] -= r, s[e] += r
            }
        }, add: function (i) {
            // console.log(this.columnsHeights, this.numberOfColumns);
            this.container.trigger("add");
            var s = t.inArray(Math.min.apply(null, this.columnsHeights), this.columnsHeights), e = 0;
            this.autoCalculation ? (i.css({visibility: "hidden"}).appendTo(this.columns.eq(s)), e = i.outerHeight(), i.detach().css({visibility: "visible"})) : e = parseInt(i.find("img").attr("height"), 10), i.attr("id") || i.attr("id", this.generateUniqueId());
            var n = this.items.toArray();
            n.push(i), this.items = t(n), this.itemsHeights[i.attr("id")] = e, this.columnsHeights[s] += e, this.columns.eq(s).append(i), this.levelBottomEdge(this.itemsHeights, this.columnsHeights), this.container.trigger("mosaicflow-layout"), this.container.trigger("added")
        }, remove: function (t) {
            this.container.trigger("remove");
            var i = t.parents("." + this.options.columnClass);
            this.columnsHeights[i.index() - 1] -= this.itemsHeights[t.attr("id")], t.detach(), this.items = this.items.not(t), this.levelBottomEdge(this.itemsHeights, this.columnsHeights), this.container.trigger("mosaicflow-layout"), this.container.trigger("removed")
        }, empty: function () {
            var i = this.numberOfColumns;
            this.items = t([]), this.itemsHeights = {};
            for (var s = 0; i > s; s++) {
                var e = this.columns.eq(s);
                this.columnsHeights[s] = 0, e.empty()
            }
            this.container.trigger("mosaicflow-layout")
        }, recomputeHeights: function () {
            function i(i, e) {
                e = t(e);
                var o = 0;
                o = s.autoCalculation ? e.outerHeight() : parseInt(e.find("img").attr("height"), 10), s.itemsHeights[e.attr("id")] = o, s.columnsHeights[n] += o
            }

            for (var s = this, e = this.numberOfColumns, n = 0; e > n; n++) {
                var o = this.columns.eq(n);
                this.columnsHeights[n] = 0, o.children().each(i)
            }
        }, generateUniqueId: function () {
            return this.__uidItemCounter++, "mosaic-" + this.__uid + "-itemid-" + this.__uidItemCounter
        }
    }, t(function () {
        t(".mosaicflow").mosaicflow()
    })
});