<?php
/**
 * SocialEngine
 *
 * @category   Application_Core
 * @package    Core
 * @copyright  Copyright 2006-2010 Webligo Developments
 * @license    http://www.socialengine.com/license/
 * @version    $Id: changelog.php 10033 2013-03-28 23:53:58Z john $
 * @author     John
 */
return array(
  '4.5.0' => array(
    'externals/scripts/composer.js' => 'Fixed positioning issue for composer on mobile',
    'externals/scripts/core.js' => 'Fixes issue with extra container when loading comments in the activity feed',
    'externals/styles/main.css' => 'Improved styles',
    'layouts/scripts/default.tpl' => 'Hides invalid elements on iPad',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-content/index.tpl' => 'Error message when widget is missing',
    'widgets/comments/Controller.php' => 'Hides comment widget when no comments and unable to comment',
  ),
  '4.3.0' => array(
    '/application/languages/en/core.csv' => 'Changed phrase in admin panel',
    'controllers/SearchController.php' => 'Added new pages to layout editor',
    'externals/images/more_dark.png' => 'Added',
    'externals/images/socialengine_logo_admin.png' => 'Changed logo',
    'externals/images/socialengine_logo_admin1.png' => 'Added',
    'externals/styles/admin/constants.css' => 'Improved admin panel styles',
    'externals/styles/admin/main.css' => 'Improved admin panel styles',
    'Form/Admin/Menu/ItemCreate.php' => 'Different',
    'layouts/scripts/admin.tpl' => 'Improved admin panel styles',
    'layouts/scripts/default.tpl' => 'Fixed issue with Janrain Social Sharing widget',
    'Model/Item/Abstract.php' => 'Fixed issue with "Shared" activity feed item not displaying the item type of what was shared.',
    'Plugin/Core.php' => 'Fixed issue with Janrain Social Sharing widget',
    'settings/changelog.php' => 'Incremented version',
    'settings/install.php' => 'Added new pages to layout editor',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.2.9-4.3.0.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_composeTag.tpl' => 'Removing usage of action helper to prevent issues',
    'views/scripts/_FancyUpload.tpl' => 'Allow mobile photo upload',
    'views/scripts/admin-content/index.tpl' => 'Improved admin panel styles',
    'views/scripts/admin-menus/index.tpl' => 'Improved admin panel styles',
    'views/scripts/admin-stats/index.tpl' => 'Fixed error when invalid filters are selected',
    'widgets/admin-dashboard/index.tpl' => 'Improved admin panel styles',
    'widgets/search/Controller.php' => 'Fixed URL issue',
  ),
  '4.2.9p1' => array(
    'controllers/AdminContentController.php' => 'Fixed errors in page structure validation',
    'Model/DbTable/Comments.php' => 'Fixed incorrect comment order',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.2.9' => array(
    'controllers/AdminContentController.php' => 'Add Option to make custom page searhchable',
    'controllers/AdminSettingsController.php' => 'Fixed Memcache Port Bug in the Caching and Performance page',
    'externals/images/nophoto_page_thumb_icon.png' => 'Added',
    'Form/Admin/Layout/Content/Page.php' => 'Add text search to Events and Groups search widgets',
    'Form/Admin/Settings/Performance.php' => 'Fixed Memcache Port Bug in the Caching and Performance page',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Added Core Widget to place the Search Bar anywhere.',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.2.8-4.2.9.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'widgets/admin-menu-main/Controller.php' => 'Remove Wibiya cfrom admin menu',
    'widgets/search/Controller.php' => 'Added',
    'widgets/search/index.tpl' => 'Added',
  ),
  '4.2.8' => array(
    'controllers/AdminMailController.php' => 'Fixes save Mail Count in Mail Settings',
    'externals/scripts/core.js' => 'Fix page refresh when comment posted',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.2.7' => array(
    'Bootstrap.php' => 'Different',
    'Controller/Action/Admin.php' => 'Added syntax checking after PHP translation arrays are created to prevent errors',
    'controllers/AdminContentController.php' => 'Added option to create a new Page Layout as a duplicate of an existing layout ',
    'controllers/AdminLanguageController.php' => 'Fixed Bug where multiple languages were not being recognized.',
    'controllers/AdminSettingsController.php' => 'Added syntax checking after PHP translation arrays are created to prevent errors.',
    'externals/styles/admin/main.css' => 'Added option to create a new Page Layout as a duplicate of an existing layout',
    'Form/Admin/Language/Translate.php' => 'Fixed Bug where multiple languages were not being recognized. Language Manager works again',
    'Form/Admin/Settings/Performance.php' => 'Added the ability to Enable and Disable Gzip Compression to the Performance and Caching page',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-content/index.tpl' => 'Added option to create a new Page Layout as a duplicate of an existing layout',
    'views/scripts/admin-language/edit.tpl' => 'Fixed Bug where multiple languages were not being recognized.',
    'widgets/admin-dashboard/index.tpl' => 'Fixes incorrect URL in admin dashboard',
  ),
  '4.2.6' => array(
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.2.5' => array(
    'Form/Admin/Mail/Templates.php' => 'Add support links',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.2.4' => array(
    '/application/languages/en/core.csv' => 'Fixed typo in the admin signup notification mail template',
    'Api/Mail.php' => 'Fixes error causing plain text e-mails to be set as html',
    'controllers/AdminLogController.php' => 'Fixes next in the log browser',
    'controllers/AdminMenusController.php' => 'Placing ban on editing non-custom menus once again',
    'controllers/AdminMessageController.php' => 'Add paragraph capability to Email All Members',
    'controllers/AdminTasksController.php' => 'Fixes Run Selected Now in Task Scheduler',
    'externals/scripts/composer_link.js' => 'If a google doc is linked in the activity feed, title and doc will be Google Document',
    'settings/changelog.php' => 'Incremented version',
    'settings/install.php' => 'Fixes anned IP address to be erased after performing an upgrade.',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-log/index.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-report/index.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-tasks/index.tpl' => 'Added support links in admin panel',
    'widgets/admin-news/index.tpl' => 'Update More SE News link',
  ),
  '4.2.3p1' => array(
    '/application/languages/en/core.csv' => 'Fixed typo in the admin signup notification mail template',
    'Api/Mail.php' => 'Fixes error causing plain text e-mails to be set as html',
    'controllers/AdminMenusController.php' => 'Fixes error when menu title is edited',
    'controllers/AdminTasksController.php' => 'Fixes Run Selected Now in Task Scheduler',
    'externals/scripts/composer_link.js' => 'If a google doc is linked in the activity feed, title and doc will be Google Document',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-report/index.tpl' => 'Fixes Run Selected Now in Task Scheduler',
    'views/scripts/admin-tasks/index.tpl' => 'Fixes Run Selected Now in Task Scheduler',
  ),
  '4.2.3' => array(
    '/application/languages/en/core.csv' => 'Admin can choose to receive email when a new user signs up',
    'Api/Mail.php' => 'Admin can choose to receive email when a new user signs up',
    'Form/Admin/Ads/Create.php' => 'Added support links in admin panel',
    'Form/Admin/Mail/Settings.php' => 'Admin can choose to receive email when a new user signs up',
    'Form/Admin/Message/Mail.php' => 'Admin can choose to receive email when a new user signs up',
    'Form/Admin/Settings/General.php' => 'Added support links in admin panel',
    'Form/Admin/Settings/Password.php' => 'Added support links in admin panel',
    'Form/Admin/Settings/Performance.php' => 'Added support links in admin panel',
    'Form/Admin/Settings/Spam.php' => 'Added support links in admin panel',
    'Form/Admin/Settings/Viglink.php' => 'Added support links in admin panel',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.2.2-4.2.3.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_formImageCrop.tpl' => 'Wraps translation for Edit Thumbnail to allow apostrophes',
    'views/scripts/admin-ads/index.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-language/index.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-log/index.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-menus/index.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-stats/index.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-stats/referrers.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-system/php.tpl' => 'Added support links in admin panel',
    'views/scripts/admin-tasks/index.tpl' => 'Added support links in admin panel',
  ),
  '4.2.2' => array(
    'Api/Settings.php' => 'Different',
    'controllers/AdminSettingsController.php' => 'Trimming parameters in Wibiya',
    'controllers/PagesController.php' => 'Fixed error message',
    'layouts/scripts/admin-simple.tpl' => 'Upgrading to MooTools 1.4',
    'layouts/scripts/admin.tpl' => 'Upgrading to MooTools 1.4',
    'layouts/scripts/default-simple.tpl' => 'Upgrading to MooTools 1.4',
    'layouts/scripts/default.tpl' => 'Upgrading to MooTools 1.4',
    'Model/Item/Abstract.php' => 'Fixed error message',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-ads/audience.tpl' => 'MooTools 1.4 compatibility',
    'views/scripts/admin-ads/index.tpl' => 'MooTools 1.4 compatibility',
    'views/scripts/admin-ads/manageads.tpl' => 'MooTools 1.4 compatibility',
    'views/scripts/admin-content/index.tpl' => 'MooTools 1.4 compatibility',
    'views/scripts/admin-report/index.tpl' => 'MooTools 1.4 compatibility',
    'views/scripts/admin-tasks/index.tpl' => 'MooTools 1.4 compatibility',
    'views/scripts/admin-tasks/processes.tpl' => 'MooTools 1.4 compatibility',
  ),
  '4.2.1' => array(
    'controllers/AdminReportController.php' => 'Fixed issue with ban user+ban ip action',
    'Form/Admin/Settings/Wibiya.php' => 'Improved Wibiya setup',
    'layouts/scripts/default.tpl' => 'Hack for removing #_=_ from facebook return',
    'Plugin/Core.php' => 'Added ability to disable Janrain share modal',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-settings/wibiya.tpl' => 'Improved Wibiya setup',
  ),
  '4.2.0' => array(
    'Api/Ad.php' => 'Fixed error when deleting an ad with an attachment',
    'Api/Core.php' => 'Added ReCaptcha support',
    'Api/Menus.php' => 'Fixed issue with menu order',
    'Api/Search.php' => 'Hiding types from disabled modules',
    'Bootstrap.php' => 'Added code to inject custom code into the head tag',
    'controllers/AdminMessageController.php' => 'Emails will no longer be sent to disabled members',
    'controllers/AdminSettingsController.php' => 'Added ReCaptcha; fixed issue with wildcard IP bans; added Wibiya',
    'controllers/AdminTasksController.php' => 'Added timeout state to job queue',
    'controllers/CrossDomainController.php' => 'Fixed error when detecting IP addresses',
    'controllers/HelpController.php' => 'Fixed issue with custom contact email',
    'controllers/LinkController.php' => 'Trim whitespace from URL in preview',
    'externals/scripts/composer.js' => 'Added namespace for Wibiya compatibility',
    'externals/scripts/composer_link.js' => 'Added namespace for Wibiya compatibility',
    'externals/scripts/composer_tag.js' => 'Added namespace for Wibiya compatibility',
    'externals/scripts/core.js' => 'Added namespace for Wibiya compatibility',
    'externals/styles/main.css' => 'Added CSS for Janrain',
    'Form/Admin/Settings/General.php' => 'Added code to inject custom code into the head tag',
    'Form/Admin/Settings/Spam.php' => 'Added ReCaptcha support',
    'Form/Admin/Settings/Viglink.php' => 'Improved description',
    'Form/Admin/Settings/Wibiya.php' => 'Added',
    'Form/Comment/Create.php' => 'Added ReCaptcha support',
    'Form/Contact.php' => 'Added ReCaptcha support',
    'layouts/scripts/admin-simple.tpl' => 'Fixed CSS issue in development mode',
    'layouts/scripts/admin.tpl' => 'Fixed CSS issue in development mode',
    'layouts/scripts/default-simple.tpl' => 'Fixed CSS issue in development mode; added code to inject custom code into the head tag',
    'layouts/scripts/default.tpl' => 'Fixed CSS issue in development mode; added code to inject custom code into the head tag',
    'Model/DbTable/BannedEmails.php' => 'Trims whitespace from emails',
    'Model/DbTable/Jobs.php' => 'Added timeout state; increased timeout limit from 20 to 60 minutes',
    'Model/DbTable/Tags.php' => 'Skipping empty values',
    'Plugin/Core.php' => 'Added Wibiya; added Janrain',
    'Plugin/Task/Statistics.php' => 'Improved reporting',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.8p1-4.2.0.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-files/index.tpl' => 'Added flash cross-domain policy file',
    'views/scripts/admin-report/index.tpl' => 'Made table scrollable',
    'views/scripts/admin-settings/wibiya.tpl' => 'Added',
    'views/scripts/admin-stats/index.tpl' => 'Chart flash is now always hosted locally to fix cross-domain issues',
    'views/scripts/admin-tasks/jobs.tpl' => 'Added timeout state to jobs',
    'views/scripts/comment/list.tpl' => 'Fixed link enabling issue; fixed CSS issue with comment option list',
    'widgets/comments/index.tpl' => 'Fixed link enabling issue; fixed CSS issue with comment option list',
  ),
  '4.1.8p1' => array(
    'controllers/AdminLogController.php' => 'Fixed issue with download log files',
    'controllers/AdminReportController.php' => 'Fixed issue with pagination count',
    'controllers/AdminTasksController.php' => 'Added new filters',
    'controllers/CrossDomainController.php' => 'Added',
    'controllers/ErrorController.php' => 'Added page to the layout editor',
    'controllers/LinkController.php' => 'Fixed issues with previewing non-UTF8, non-English pages',
    'controllers/UtilityController.php' => 'Added cross domain policy file for CDN support',
    'Form/Admin/Job/Filter.php' => 'Added new filters',
    'Form/Admin/Settings/General.php' => 'Upload quota should be in member levels settings page',
    'layouts/scripts/admin-simple.tpl' => 'Content-Language meta tag is now set to the language of the selected language pack',
    'layouts/scripts/admin.tpl' => 'Content-Language meta tag is now set to the language of the selected language pack',
    'layouts/scripts/default-simple.tpl' => 'Content-Language meta tag is now set to the language of the selected language pack',
    'layouts/scripts/default.tpl' => 'Content-Language meta tag is now set to the language of the selected language pack',
    'Model/DbTable/Jobs.php' => 'Added timeout of jobs after 20 minutes of execution to prevent stalling video encodes',
    'Plugin/Core.php' => 'Reports are no longer deleted when reported object is deleted',
    'Plugin/Task/Jobs.php' => 'Added timeout of jobs after 20 minutes of execution to prevent stalling video encodes',
    'settings/changelog.php' => 'Incremented version',
    'settings/install.php' => 'Added page to the layout editor',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.8-4.1.8p1.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_FancyUpload.tpl' => 'Added cross domain policy file for CDN support',
    'views/scripts/admin-stats/index.tpl' => 'Fixed type in URL that would cause charts to not load',
    'views/scripts/cross-domain/index.tpl' => 'Added',
  ),
  '4.1.8' => array(
    '/application/languages/en/core.csv' => 'Added phrases',
    'Api/Abstract.php' => 'Removed deprecated method',
    'Api/Ad.php' => 'Removed deprecated method call',
    'Api/Core.php' => 'Removed deprecated method call',
    'Api/Menus.php' => 'Removed deprecated method call',
    'Bootstrap.php' => 'Added static base URL for CDN support',
    'Controller/Action/Helper/RequireAbstract.php' => 'Fixed issue with incorrect forward after reset',
    'controllers/AdminContentController.php' => 'Added categories and sorting to page list; added nomobile auto option to widgets',
    'controllers/AdminMailController.php' => 'Added configurable address for contact form',
    'controllers/AdminServicesController.php' => 'Added svn:keywords',
    'controllers/AdminSettingsController.php' => 'Added static base URL for CDN support; added Google Analytics; added optional built-in affiliate banner',
    'controllers/AdminTasksController.php' => 'Fixed issue preventing adding jobs without a default form',
    'controllers/CommentController.php' => 'Added stats for likes',
    'controllers/ErrorController.php' => 'Fixed exception caused by incorrect forward',
    'controllers/HelpController.php' => 'Added pages to the layout editor; Added configurable address for contact form',
    'controllers/ReportController.php' => 'Removed deprecated routes',
    'controllers/UtilityController.php' => 'Fixed issue with changing themes',
    'externals/.htaccess' => 'Updated with far-future expires headers for static resources',
    'externals/images/help.png' => 'Added',
    'externals/scripts/composer.js' => 'Added ability to disable contentEditable support; Added static base URL for CDN support',
    'externals/scripts/composer_link.js' => 'Added code to help troubleshoot image loading issues',
    'externals/scripts/core.js' => 'Improved AJAX page loader',
    'externals/styles/admin/main.css' => 'Added styles for layout editor tweaks',
    'externals/styles/main.css' => 'Added styles for affiliate banner',
    'externals/styles/mobile.css' => 'Added styles for affiliate banner',
    'Form/Admin/Layout/Content/Page.php' => 'Removed deprecated routes',
    'Form/Admin/Mail/Settings.php' => 'Added configurable address for contact form',
    'Form/Admin/Report/Action.php' => 'Added svn:keywords',
    'Form/Admin/Settings/Affiliate.php' => 'Added',
    'Form/Admin/Settings/General.php' => 'Added static base URL for CDN support; added Google Analytics; added optional built-in affiliate banner',
    'Form/Admin/Settings/License.php' => 'Added trim to input',
    'Form/Admin/Settings/Viglink.php' => 'Added',
    'layouts/scripts/admin-simple.tpl' => 'Added static base URL for CDN support',
    'layouts/scripts/admin.tpl' => 'Added static base URL for CDN support',
    'layouts/scripts/default-simple.tpl' => 'Added static base URL for CDN support',
    'layouts/scripts/default.tpl' => 'Added static base URL for CDN support',
    'Model/Abstract.php' => 'Removed deprecated method',
    'Model/Api.php' => 'Removed',
    'Model/Comment.php' => 'Fixed fatal error with orphaned rows',
    'Model/DbTable/BannedEmails.php' => 'Fixed issue where exception would be thrown on duplicate input',
    'Model/DbTable/BannedIps.php' => 'Fixed issue where exception would be thrown on duplicate input',
    'Model/DbTable/BannedUsernames.php' => 'Added svn:keywords',
    'Model/DbTable/Content.php' => 'Removed deprecated code',
    'Model/DbTable/Pages.php' => 'Removed deprecated code; added nomobile auto option to widgets',
    'Model/Item/Abstract.php' => 'Removed deprecated code; fixed intl issue with URL slugs; isOwner no longer throws an exception if owner cannot be found',
    'Plugin/Core.php' => 'Added plugin code for Google Analytics and VigLink',
    'Plugin/Task/Mail.php' => 'Fixed errors',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Added pages to the layout editor',
    'settings/install.php' => 'Added pages to the layout editor',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.7-4.1.8.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'View/Helper/ItemPhoto.php' => 'Added static base URL for CDN support',
    'views/scripts/_composeLink.tpl' => 'Added static base URL for CDN support',
    'views/scripts/_composeTag.tpl' => 'Added static base URL for CDN support',
    'views/scripts/_FancyUpload.tpl' => 'Added static base URL for CDN support,Sets the FancyUpload timeLimit directive to 0',
    'views/scripts/_formImageCrop.tpl' => 'Added static base URL for CDN support',
    'views/scripts/admin-ads/create.tpl' => 'Added static base URL for CDN support',
    'views/scripts/admin-ads/edit.tpl' => 'Added static base URL for CDN support',
    'views/scripts/admin-ads/index.tpl' => 'Added link to KB',
    'views/scripts/admin-ads/manageads.tpl' => 'Added static base URL for CDN support',
    'views/scripts/admin-content/index.tpl' => 'Added categories and sorting to page list; Added static base URL for CDN support',
    'views/scripts/admin-files/index.tpl' => 'Added static base URL for CDN support',
    'views/scripts/admin-menus/delete-menu.tpl' => 'Added svn:keywords',
    'views/scripts/admin-report/action.tpl' => 'Added svn:keywords',
    'views/scripts/admin-services/change.tpl' => 'Added svn:keywords',
    'views/scripts/admin-services/create.tpl' => 'Added svn:keywords',
    'views/scripts/admin-services/edit.tpl' => 'Added svn:keywords',
    'views/scripts/admin-services/index.tpl' => 'Added svn:keywords',
    'views/scripts/admin-settings/affiliate.tpl' => 'Added',
    'views/scripts/admin-settings/viglink.tpl' => 'Added',
    'views/scripts/admin-stats/index.tpl' => 'Added static base URL for CDN support',
    'views/scripts/admin-tasks/jobs.tpl' => 'Added static base URL for CDN support',
    'views/scripts/admin-themes/index.tpl' => 'Added static base URL for CDN support; Added link to KB',
    'views/scripts/admin-themes/themes.tpl' => 'Added static base URL for CDN support',
    'widgets/ad-campaign/index.tpl' => 'Compatibility for AJAX page loader',
    'widgets/admin-menu-logo/index.tpl' => 'Added static base URL for CDN support',
    'widgets/admin-menu-mini/index.tpl' => 'Added static base URL for CDN support',
    'widgets/admin-news/Controller.php' => 'Added caching',
    'widgets/admin-news/index.tpl' => 'Added caching',
    'widgets/contact/Controller.php' => 'Added',
    'widgets/contact/index.tpl' => 'Added',
    'widgets/container-tabs/index.tpl' => 'Compatibility for AJAX page loader',
    'widgets/menu-footer/Controller.php' => 'Added optional built-in affiliate banner',
    'widgets/menu-footer/index.tpl' => 'Added optional built-in affiliate banner',
    'widgets/menu-logo/index.tpl' => 'Removed deprecated routes',
    'widgets/menu-mini/index.tpl' => 'Added static base URL for CDN support; Compatibility for AJAX page loader',
    'widgets/profile-links/index.tpl' => 'Added pagination',
    'widgets/theme-choose/Controller.php' => 'Added svn:keywords',
    'widgets/theme-choose/index.tpl' => 'Added svn:keywords',
  ),
  '4.1.7' => array(
    '/application/languages/en/core.csv' => 'Added phrases',
    'Api/Mail.php' => 'Minor optimizations',
    'Bootstrap.php' => 'Minor optimizations',
    'controllers/AdminAdsController.php' => 'Removing deprecated usage of $this->_helper->api()',
    'controllers/AdminMenusController.php' => 'Fixed error when order of a menu item is null',
    'controllers/AdminServicesController.php' => 'Added',
    'controllers/AdminSettingsController.php' => 'Banned IPs setting checks if you are banning your own IP address now',
    'controllers/SearchController.php' => 'Code formatting',
    'controllers/UtilityController.php' => 'Added ability to select a theme; minor optimizations',
    'Form/Admin/Services/Change.php' => 'Added',
    'Form/Admin/Services/Create.php' => 'Added',
    'Form/Admin/Settings/Spam.php' => 'Banned IPs setting checks if you are banning your own IP address now',
    'layouts/scripts/admin-simple.tpl' => 'Upgraded MooTools to 1.3 (compat)',
    'layouts/scripts/admin.tpl' => 'Upgraded MooTools to 1.3 (compat)',
    'layouts/scripts/default-simple.tpl' => 'Upgraded MooTools to 1.3 (compat)',
    'layouts/scripts/default.tpl' => 'Upgraded MooTools to 1.3 (compat)',
    'Model/Adcampaign.php' => 'Minor optimizations',
    'Model/DbTable/BannedEmails.php' => 'Fixed issue where wildcards would not be escaped properly',
    'Model/DbTable/BannedIps.php' => 'Banned IPs setting checks if you are banning your own IP address now',
    'Model/DbTable/Config.php' => 'Removed',
    'Model/DbTable/Modules.php' => 'Minor optimizations',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.1-4.1.2.sql' => 'Fixed issue when upgrading from <= 4.1.0',
    'settings/my-upgrade-4.1.6p3-4.1.7.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'View/Helper/ItemPhoto.php' => 'Modified helper method to help get nophoto icons',
    'views/scripts/admin-ads/index.tpl' => 'Minor optimizations',
    'views/scripts/admin-services/change.tpl' => 'Added',
    'views/scripts/admin-services/create.tpl' => 'Added',
    'views/scripts/admin-services/edit.tpl' => 'Added',
    'views/scripts/admin-services/index.tpl' => 'Added',
    'widgets/theme-choose/Controller.php' => 'Added',
    'widgets/theme-choose/index.tpl' => 'Added',
  ),
  '4.1.6p3' => array(
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.1-4.1.2.sql' => 'Fixed issue when upgrading from 4.1.0',
    'settings/my.sql' => 'Incremented version',
  ),
  '4.1.6' => array(
    'Api/Facebook.php' => 'Removed deprecated code',
    'controllers/AdminAdsController.php' => 'Ad start and end dates now use the admin\'s timezone instead of UTC',
    'controllers/AdminMenusController.php' => 'Custom menus can now be deleted',
    'controllers/AdminReportController.php' => 'Added options for handling reports',
    'controllers/AdminSettingsController.php' => 'Added banned emails and banned usernames; added IPv6 support to banned IPs',
    'controllers/CommentController.php' => 'Fixed XSS vulnerability in comments',
    'controllers/ErrorController.php' => 'Removed deprecated code',
    'externals/images/menus_deletemenu.png' => 'Added',
    'externals/scripts/composer_link.js' => 'Fixed XSS vulnerability in attached link title and description',
    'externals/styles/admin/main.css' => 'Added styles',
    'Form/Admin/Report/Action.php' => 'Added',
    'Form/Admin/Settings/Spam.php' => 'Added banned emails and banned usernames; added IPv6 support to banned IPs',
    'Model/Report.php' => 'Added method to get report subject',
    'Model/DbTable/BannedEmails.php' => 'Added interaction methods',
    'Model/DbTable/BannedIps.php' => 'Added interaction methods',
    'Model/DbTable/BannedUsernames.php' => 'Added',
    'Model/DbTable/BannedWords.php' => 'Added interaction methods',
    'Model/DbTable/Jobs.php' => 'Added lookup method',
    'Plugin/Composer.php' => 'Fixed XSS vulnerability in attached link title and description',
    'settings/changelog.php' => 'Incremented version',
    'settings/install.php' => 'Added IPv6 support',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.5-4.1.6.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-menus/delete-menu.tpl' => 'Added',
    'views/scripts/admin-menus/index.tpl' => 'Added delete link for custom menus',
    'views/scripts/admin-nodes/index.tpl' => 'Added IPv6 support',
    'views/scripts/admin-report/action.tpl' => 'Added',
    'views/scripts/admin-report/index.tpl' => 'Added options for handling reports',
    'widgets/menu-footer/index.tpl' => 'Added ucfirst() to language names',
  ),
  '4.1.5' => array(
    'controllers/AdminSettingsController.php' => 'Fixed issues with banning ips and censored words',
    'controllers/ErrorController.php' => 'Missing a space for the server protocol headers in the requireuserAction function',
    'externals/images/delete.png' => 'Added',
    'externals/styles/main.css' => 'Added delete icon class',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'widgets/profile-links/index.tpl' => 'Delete icon class change',
  ),
  '4.1.4' => array(
    '/application/languages/en/core.csv' => 'Added phrases',
    'Bootstrap.php' => 'Fixed initialization order issue that would cause the sitemap to be rendered incorrectly',
    'Controller/Action/Helper/ContextSwitch.php' => 'Added frame context',
    'controllers/AdminContentController.php' => 'Added exemption for mobile header and footer; fixed issue with displaying levels box after save for non-custom pages',
    'controllers/AdminSettingsController.php' => 'Fixed issues with banning ips and censored words',
    'controllers/AdminStatsController.php' => 'Fixes timezone issue and incorrect periods',
    'externals/scripts/composer.js' => 'Fixed overtext issue',
    'externals/styles/main.css' => 'Added loading icon class; Width style change for CAPTCHA',
    'externals/styles/mobile.css' => 'Added',
    'Form/Admin/Settings/Spam.php' => 'Style tweak',
    'Form/Confirm.php' => 'Added',
    'layouts/scripts/admin-simple.tpl' => 'Changed mootools version to fix IE9 issues',
    'layouts/scripts/admin.tpl' => 'Changed mootools version to fix IE9 issues',
    'layouts/scripts/default-simple.tpl' => 'Changed mootools version to fix IE9 issues',
    'layouts/scripts/default.tpl' => 'Changed mootools version to fix IE9 issues',
    'Model/DbTable/BannedEmails.php' => 'Added',
    'Model/DbTable/BannedIps.php' => 'Added',
    'Model/DbTable/BannedWords.php' => 'Added',
    'Model/DbTable/Tags.php' => 'Tagged items are now orderd by creation date',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Made Tab Container special',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.3-4.1.4.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-content/index.tpl' => 'Fixed language',
    'views/scripts/admin-settings/spam.tpl' => 'Added menu for login history',
    'views/scripts/sitemap/index.xml.tpl' => 'Fixed issue with sitemap generation',
    'widgets/admin-dashboard/index.tpl' => 'Fixed broken links',
    'widgets/admin-statistics/Controller.php' => 'Added display of current version',
    'widgets/admin-statistics/index.tpl' => 'Added display of current version',
    'widgets/menu-generic/index.tpl' => 'Fixed issue with UL class name sometimes not being set',
    'widgets/menu-mini/index.tpl' => 'Fixed issue with marking all notification as read not working when global search is disabled',
  ),
  '4.1.3' => array(
    '/application/languages/en/core.csv' => 'Added phrases',
    'Api/Adcampaign.php' => 'Removed',
    'Api/Report.php' => 'Removed',
    'controllers/AdminAdsController.php' => 'Removing deprecated code',
    'controllers/AdminFilesController.php' => 'Improved error handling',
    'controllers/AdminReportController.php' => 'Fixing pagination for manager reports page',
    'externals/scripts/composer.js' => 'Fixed issue where an empty box will show up on some themes after making an attachement to a message',
    'externals/styles/admin/main.css' => 'Added styles',
    'Form/Admin/Filter.php' => 'Fixing pagination for manager reports page',
    'Model/DbTable/Membership.php' => 'Fixed issues with one-way friendships',
    'Model/Item/Abstract.php' => 'Fixed issue with indexing items on creation',
    'settings/changelog.php' => 'Incremented version',
    'settings/manifest.php' => 'Incremented version',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-content/index.tpl' => 'Fixed issue where widgets with title NULL caused an exception.',
    'views/scripts/admin-report/index.tpl' => 'Fixing pagination for manager reports page',
    'widgets/admin-statistics/Controller.php' => 'Fixed users online count in admin dashboard.',
    'widgets/menu-main/index.tpl' => 'Fixed issue of the main navigation inheriting other UL class on the page',
  ),
  '4.1.2' => array(
    '/application/languages/en/core.csv' => 'Added phrases',
    'Api/Settings.php' => 'Refactored',
    'Bootstrap.php' => 'Added ability to use database logging; added server node tracking',
    'controllers/AdminAdsController.php' => 'Fixed pagination in ads; added statuses indicating why the ad is disabled',
    'controllers/AdminContentController.php' => 'Adding preliminary enhancements; fixed issues with population default configuration form elements',
    'controllers/AdminIndexController.php' => 'Adds fault-tolerance to switching development modes',
    'controllers/AdminLogController.php' => 'Added',
    'controllers/AdminMessageController.php' => 'Added docblock',
    'controllers/AdminNodesController.php' => 'Added',
    'controllers/AdminReportController.php' => 'Fixed issue when viewing reports when the item is deleted',
    'controllers/AdminSystemController.php' => 'Moved log browser to admin log controller',
    'controllers/AdminTasksController.php' => 'Fixed escaping issue with cron form description; fixed issue with resetting stats',
    'controllers/AdminThemesController.php' => 'Refactored meta key in package manifests',
    'controllers/CommentController.php' => 'Added the ability to like comments',
    'controllers/LinkController.php' => 'Silenced notice',
    'externals/scripts/composer.js' => 'Fixed focusing issue with the overtext in the feed composer',
    'externals/scripts/core.js' => 'Added the ability to like comments',
    'externals/styles/admin/main.css' => 'Added styles',
    'externals/styles/main.css' => 'Added styles',
    'Form/Admin/Ads/Create.php' => 'All levels are now selected by default',
    'Model/Adcampaign.php' => 'Improved show/hide algorithm',
    'Model/Comment.php' => 'Added the ability to like comments',
    'Model/DbTable/Nodes.php' => 'Added',
    'Model/DbTable/Settings.php' => 'Refactored',
    'Model/DbTable/Tasks.php' => 'Fixed issue where some tasks would be trigger more often than necessary; added database logging if configured; fixed possible issue on IIS',
    'Plugin/Core.php' => 'Reports are now deleted when the subject of the report is deleted',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Added configuration options to widgets',
    'settings/install.php' => 'Removes deprecated public column in ads',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.1.1-4.1.2.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_composeLink.tpl' => 'Fixed javascript escaping issue',
    'views/scripts/admin-ads/index.tpl' => 'Added pagination',
    'views/scripts/admin-ads/manageads.tpl' => 'Added pagination',
    'views/scripts/admin-log/index.tpl' => 'Added',
    'views/scripts/admin-log/settings.tpl' => 'Added',
    'views/scripts/admin-nodes/index.tpl' => 'Added',
    'views/scripts/admin-report/index.tpl' => 'Fixed issue when viewing reports when the item is deleted',
    'views/scripts/admin-report/view.tpl' => 'Added',
    'views/scripts/admin-system/log.tpl' => 'Removed',
    'views/scripts/admin-tasks/index.tpl' => 'Adjusted styles',
    'views/scripts/admin-themes/index.tpl' => 'Refactored meta key in package manifests',
    'views/scripts/admin-themes/themes.tpl' => 'Refactored meta key in package manifests',
    'views/scripts/comment/list.tpl' => 'Added the ability to like comments',
    'views/scripts/help/privacy.tpl' => 'Adds nl2br support to terms and privacy pages',
    'views/scripts/help/terms.tpl' => 'Adds nl2br support to terms and privacy pages',
    'widgets/ad-campaign/Controller.php' => 'Modifications to information methods',
    'widgets/admin-statistics/index.tpl' => 'Fixed IE8 text alignment issue',
    'widgets/comments/Controller.php' => 'Added',
    'widgets/comments/index.tpl' => 'Added',
    'widgets/menu-mini/index.tpl' => 'Fixed issue with marking all notification as read when clicking a notification',
    'widgets/statistics/Controller.php' => 'Fixed comment count discrepancy',
  ),
  '4.1.1' => array(
    '/application/languages/en/core.csv' => 'Fixed minor admin panel description typos',
    'Api/Ad.php' => 'Changes for storage system modifications',
    'Api/Links.php' => 'Fixed issue with undefined function on some servers',
    'Bootstrap.php' => 'Fixes view stats counting smoothboxes and admin views',
    'Controller/Action/Standard.php' => 'Fixes view stats counting smoothboxes and admin views',
    'controllers/AdminLanguageController.php' => 'Fixed page title issue; fixed problem when creating phrases that do not exist in the english pack',
    'controllers/AdminMenusController.php' => 'Added ability to add new menu',
    'controllers/AdminTasksController.php' => 'Fixed issue with adding jobs manually',
    'controllers/CommentController.php' => 'Fixed issue preventing viewing comments when not allowed to comment',
    'externals/.htaccess' => 'Added keywords; removed deprecated code',
    'externals/images/admin/menus_addmenu.png' => 'Added; icon for adding a new menu',
    'externals/styles/admin/main.css' => 'Added css for adding new menu; styles for italics on layout editor',
    'Form/Admin/Job/FileDownload.php' => 'Added docblock',
    'Form/Admin/Job/FileUpload.php' => 'Added docblock',
    'Form/Admin/Job/Filter.php' => 'Added docblock',
    'Form/Admin/Job/Generic.php' => 'Added',
    'Form/Admin/Layout/Content/Page.php' => 'Dynamically create page URLs',
    'Form/Admin/Menu/ItemCreate.php' => 'Enabled checkbox defaults to checked',
    'Form/Admin/Menu/MenuCreate.php' => 'Added',
    'Form/Admin/Settings/General.php' => 'Changes for storage system modifications',
    'layouts/scripts/admin-simple.tpl' => 'Added translation of page titles',
    'layouts/scripts/admin.tpl' => 'Added translation of page titles',
    'layouts/scripts/default-simple.tpl' => 'Added translation of page titles',
    'layouts/scripts/default.tpl' => 'Added translation of page titles',
    'Model/Adcampaign.php' => 'Fixed issue with correctly showing ads',
    'Model/Adphoto.php' => 'Changes for storage system modifications',
    'Model/DbTable/Tags.php' => 'Added timestamp to tagging',
    'Model/Item/Abstract.php' => 'Changes for storage system modifications',
    'Plugin/Task/LogRotation.php' => 'Added',
    'settings/changelog.php' => 'Incremented version',
    'settings/install.php' => 'Fixed issue with populating custom page level column with default values',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.5-4.1.0.sql' => 'Fixed incorrect query',
    'settings/my-upgrade-4.1.0-4.1.1.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-content/index.tpl' => 'Added italics to save button text when there are unsaved modifications',
    'views/scripts/admin-menus/create-menu.tpl' => 'Added ability to add new menu',
    'views/scripts/admin-menus/create.tpl' => 'Added ability to add new menu',
    'views/scripts/admin-menus/index.tpl' => 'Fixed issue with redirect',
    'views/scripts/comment/list.tpl' => 'Fixed issue preventing viewing comments when not allowed to comment',
    'widgets/ad-campaign/Controller.php' => 'Fixed issue with correctly showing ads',
    'widgets/admin-dashboard/index.tpl' => 'Fixed incorrect URL to package manager',
    'widgets/menu-mini/index.tpl' => 'Fixed incorrect function name to mark all notification as read',
  ),
  '4.1.0' => array(
    '/application/languages/en/core.csv' => 'Fixed phrases with stray double-quotes',
    'Api/Mail.php' => 'Fixes empty mail placeholders from not being translated',
    'Api/Search.php' => 'Fixed issue with types from disabled modules',
    'Bootstrap.php' => 'Sets iconv encoding to UTF-8 if available; modified hooks to support new tasks triggering methods; fixed issue with cache initialization; fixed issue with log initializaition; fixed issue with missing default route; added code to handle js/css version counter; tweaks for CLI support',
    'Controller/Action/Helper/FormSequence.php' => 'Fixed initialization issue',
    'controllers/AdminAdsController.php' => 'Fixed issue where selecting no end time could prevent editing',
    'controllers/AdminAuthController.php' => 'Tweaks for CLI support',
    'controllers/AdminContentController.php' => 'Support for restricting access to pages based on member level',
    'controllers/AdminIndexController.php' => 'Created method to update trial licenses',
    'controllers/AdminMenusController.php' => 'Fixed issue with saving target/enabled',
    'controllers/AdminSettingsController.php' => 'Fixed typo for Xcache cache setting; added notice on form save',
    'controllers/AdminStatsController.php' => 'Fixed timezone issue with statistics showing only GMT periods',
    'controllers/AdminTasksController.php' => 'Added job queue; simplified tasks system',
    'controllers/AdminThemesController.php' => 'Added code to handle js/css version counter and cache flushing on save',
    'controllers/CommentController.php' => 'Added comment body to feed item',
    'controllers/ErrorController.php' => '404s are no longer sent to the error log',
    'controllers/IndexController.php' => 'Silencing errors in the content system',
    'controllers/LinkController.php' => 'Improved link support: now supports web pages, images, and text documents',
    'controllers/PagesController.php' => 'Support for restricting access to pages based on member level; silencing errors in the content system',
    'controllers/ReportController.php' => 'Added notice on report submission',
    'controllers/TagController.php' => 'Fixed issue with adding a tag; fixed missing notification variable',
    'controllers/UtilityController.php' => 'Date now included in cron execute echo for logging',
    'externals/.htaccess' => 'Added svn:keywords',
    'externals/images/move_down.png' => 'Added',
    'externals/images/move_up.png' => 'Added',
    'externals/scripts/composer_link.js' => 'Fixed problem where images would not be filtered by size correctly',
    'externals/scripts/core.js' => 'Added environment variable for javascript debugging',
    'externals/styles/admin/constants.css' => 'Added svn:keywords',
    'externals/styles/admin/main.css' => 'Added styles',
    'externals/styles/main.css' => 'Added styles',
    'Form/Admin/Index/LicenseKey.php' => 'Added; created method to update trial licenses',
    'Form/Admin/Job/FileDownload.php' => 'Added',
    'Form/Admin/Job/FileUpload.php' => 'Added',
    'Form/Admin/Job/Filter.php' => 'Added',
    'Form/Admin/Layout/Content/Page.php' => 'Support for restricting access to pages based on member level',
    'Form/Admin/Mail/Settings.php' => 'Added option for mail queue batch size',
    'Form/Admin/Menu/ItemCreate.php' => 'Added icon support to custom menu items',
    'Form/Admin/Settings/General.php' => 'Added ability to specify maintenance code',
    'Form/Admin/Settings/License.php' => 'Added',
    'Form/Admin/Settings/Performance.php' => 'Settings cannot be changed in development mode',
    'Form/Admin/System/Log.php' => 'Fixed issue with url',
    'Form/Admin/Tasks/Filter.php' => 'Simplified tasks system',
    'Form/Admin/Tasks/Settings.php' => 'Added new options for tasks and jobs',
    'Form/Report.php' => 'Adjusted form URL',
    'layouts/scripts/admin-simple.tpl' => 'Added code to handle js/css version counter',
    'layouts/scripts/admin.tpl' => 'Added code to handle js/css version counter',
    'layouts/scripts/default-simple.tpl' => 'Added code to handle js/css version counter',
    'layouts/scripts/default.tpl' => 'Added code to handle js/css version counter',
    'Model/DbTable/Jobs.php' => 'Added',
    'Model/DbTable/JobTypes.php' => 'Added',
    'Model/DbTable/Log.php' => 'Added',
    'Model/DbTable/Processes.php' => 'Added',
    'Model/DbTable/Session.php' => 'Added method to destroy session to force users to be logged out for payment',
    'Model/DbTable/Statistics.php' => 'Fixed timezone issue with statistics showing only GMT periods',
    'Model/DbTable/Tasks.php' => 'Simplified tasks system',
    'Model/DbTable/Themes.php' => 'Added code to flush cache on save',
    'Model/Item/Abstract.php' => 'Silencing exceptions throw in the toString() method',
    'Model/Link.php' => 'Fixed permissions issue with deletion',
    'Model/Page.php' => 'Support for restricting access to pages based on member level',
    'Plugin/FormSequence/Abstract.php' => 'Code formatting',
    'Plugin/Job/Abstract.php' => 'Added',
    'Plugin/Job/FileDownload.php' => 'Added',
    'Plugin/Job/FileUpload.php' => 'Added',
    'Plugin/Task/Abstract.php' => 'Simplified tasks system',
    'Plugin/Task/Jobs.php' => 'Added',
    'Plugin/Task/Mail.php' => 'Fixed issue with infinite loop when the mail template is missing',
    'Plugin/Task/PersistentAbstract.php' => 'Removed',
    'settings/changelog.php' => 'Incremented version',
    'settings/content.php' => 'Added pagination/item count limits to widgets',
    'settings/install.php' => 'Support for restricting access to pages based on member level',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.0beta3-4.0.0rc1.sql' => 'Backwards compatibility fix for tasks modifications',
    'settings/my-upgrade-4.0.0rc1-4.0.0rc2.sql' => 'Backwards compatibility fix for tasks modifications',
    'settings/my-upgrade-4.0.3p1-4.0.4.sql' => 'Backwards compatibility fix for tasks modifications',
    'settings/my-upgrade-4.0.4-4.0.5.sql' => 'Backwards compatibility fix for tasks modifications',
    'settings/my-upgrade-4.0.5-4.1.0.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'View/Helper/PageLinks.php' => 'Refactored; added itemCountPerPage support',
    'views/scripts/_composeTag.tpl' => 'Fixed incorrect url',
    'views/scripts/_navIcons.tpl' => 'Fixed "open in a new window" support',
    'views/scripts/admin-content/index.tpl' => 'Fixed JSON decode issue',
    'views/scripts/admin-index/license-key.tpl' => 'Added; created method to update trial licenses',
    'views/scripts/admin-tasks/index.tpl' => 'Simplified tasks system',
    'views/scripts/admin-tasks/job-add.tpl' => 'Added',
    'views/scripts/admin-tasks/job-messages.tpl' => 'Added',
    'views/scripts/admin-tasks/jobs.tpl' => 'Added',
    'views/scripts/admin-tasks/processes.tpl' => 'Added',
    'views/scripts/error/error.tpl' => 'Added error codes',
    'views/scripts/pagination/search.tpl' => 'Fixed missing URL',
    'widgets/admin-dashboard/Controller.php' => 'Added database-based admin notifications',
    'widgets/admin-dashboard/index.tpl' => 'Added database-based admin notifications',
    'widgets/admin-news/index.tpl' => 'Fixed UTF-8 truncation issues',
    'widgets/admin-statistics/Controller.php' => 'Created method to update trial licenses',
    'widgets/container-tabs/Controller.php' => 'Fixed ability to link directly to a tab',
    'widgets/container-tabs/index.tpl' => 'Fixed ability to link directly to a tab',
    'widgets/profile-links/Controller.php' => 'Added pagination/item count limit',
  ),
  '4.0.5' => array(
    'Api/Mail.php' => 'Added logging while in development mode',
    'Bootstrap.php' => 'Fixed issue with session resuming for fancyupload; added fatal error logging; removed logging of caught exceptions in production mode',
    'Controller/Action/Helper/ContextSwitch.php' => 'Fixed issue with FastCGI and duplicate Content-Type headers',
    'controllers/AdminContentController.php' => 'Fixed issue with blank pages for some versions of MySQL; fixed issue preventing saving of page info if a page is saved without a url; added some more default options to widget edit form',
    'controllers/AdminLanguageController.php' => 'Fixed issue with plural variables in non-plural languages',
    'controllers/AdminSystemController.php' => 'Line break improvement',
    'controllers/AdminTasksController.php' => 'Fixed issue with tasks in disabled modules; fixed incorrect url generated for cronjob mode; added link to the task log',
    'controllers/CommentController.php' => 'Tweak for issue with duplicate Content-Type headers',
    'controllers/ErrorController.php' => 'Improved language; removed deprecated code; improved logging',
    'controllers/HelpController.php' => 'Added ability to attach error message invisibly when following link from the error page',
    'controllers/LinkController.php' => 'Added compatibility for when the DOM extension is missing',
    'controllers/PagesController.php' => 'Compatibility for metadata improvements',
    'externals/scripts/composer.js' => 'Fixed issue caused by different handling by different browsers of line breaks in contentEditable',
    'externals/styles/admin/main.css' => 'Added styles',
    'externals/styles/main.css' => 'Added styles',
    'Form/Admin/Ads/Create.php' => 'Code formatting',
    'Form/Admin/Layout/Content/Page.php' => 'Fixed issue in filtering page url in content editor',
    'Form/Admin/Tasks/Filter.php' => 'ixed issue with tasks in disabled modules',
    'Form/Contact.php' => 'Added ability to attach error message invisibly when following link from the error page',
    'layouts/scripts/admin-simple.tpl' => 'Code formatting',
    'layouts/scripts/admin.tpl' => 'Code formatting',
    'layouts/scripts/default-simple.tpl' => 'Code formatting',
    'layouts/scripts/default.tpl' => 'Code formatting',
    'Model/Abstract.php' => 'Improved error message',
    'Model/Ad.php' => 'Compat for search indexing changes',
    'Model/Adcampaign.php' => 'Compat for search indexing changes',
    'Model/Adphoto.php' => 'Compat for search indexing changes',
    'Model/Comment.php' => 'Compat for search indexing changes',
    'Model/DbTable/Pages.php' => 'Added metadata and layout support for built-in pages; fixed issue with blank pages for some versions of MySQL',
    'Model/DbTable/Status.php' => 'Moved from Core_Model_Status_Standard',
    'Model/DbTable/Tasks.php' => 'Added idle support; fixed issue with clearing out frozen or dead tasks',
    'Model/GeoTag.php' => 'Compat for search indexing changes',
    'Model/Item/Abstract.php' => 'Fixed issues with search indexing; added default slug method',
    'Model/Like.php' => 'Compat for search indexing changes',
    'Model/List.php' => 'Compat for search indexing changes',
    'Model/ListItem.php' => 'Compat for search indexing changes',
    'Model/MailTemplate.php' => 'Compat for search indexing changes',
    'Model/Page.php' => 'Compat for search indexing changes',
    'Model/Report.php' => 'Compat for search indexing changes',
    'Model/Status/Exception.php' => 'Removed',
    'Model/Status/Standard.php' => 'Removed',
    'Model/Style.php' => 'Compat for search indexing changes',
    'Model/Tag.php' => 'Compat for search indexing changes',
    'Model/TagMap.php' => 'Compat for search indexing changes',
    'Plugin/Task/Abstract.php' => 'Added idle and logging support',
    'Plugin/Task/Mail.php' => 'Added idle support',
    'Plugin/Task/PersistentAbstract.php' => 'Added docblock',
    'Plugin/Task/Prefetch.php' => 'Added placeholder',
    'Plugin/Task/Statistics.php' => 'Added idle support',
    'settings/changelog.php' => 'Added',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.4-4.0.5.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/admin-content/widget.tpl' => 'Fixed issue with populating values in radio elements',
    'views/scripts/admin-files/delete.tpl' => 'Tweaked page refresh',
    'views/scripts/admin-stats/index.tpl' => 'Fixed javascript error in IE8',
    'views/scripts/error/error.tpl' => 'Improved language',
    'views/scripts/pagination/search.tpl' => 'Improved query string support',
    'widgets/ad-campaign/Controller.php' => 'Fixed issue with displaying ads',
    'widgets/menu-footer/index.tpl' => 'Added support for opening links in a new window',
    '/application/languages/en/core.csv' => 'Added missing phrases',
  ),
  '4.0.4' => array(
    'Api/Mail.php' => 'System emails now send in the language of the recipient, if available; added lots of automatic params; better HTML support; there are now header templates (one for members and one for non-members)',
    'Api/Search.php' => 'Broke getPaginator into two methods',
    'Bootstrap.php' => 'Fixed language selection issue when regions are used',
    'controllers/AdminLanguageController.php' => 'Fixed bug in translation of language names',
    'controllers/AdminMailController.php' => 'Fixed a couple bugs that prevented saving',
    'controllers/AdminSettingsController.php' => 'Fixed issue with public profile viewing and migrations',
    'controllers/AdminSystemController.php' => 'Other logs now show up; faster tail implementation for very large files',
    'controllers/AdminTasksController.php' => 'Added pagination; added auto-refresh; run now forces tasks from dormant to ready instead of running in the request; and much more',
    'controllers/UtilityController.php' => 'Trying to fix IE javascript problem',
    'externals/images/back_rtl.png' => 'Added',
    'externals/images/next_rtl.png' => 'Added',
    'externals/images/previous_rtl.png' => 'Added',
    'externals/images/star_big_half_rtl.png' => 'Added',
    'externals/images/star_half.png' => 'Added',
    'externals/images/star_half_rtl.png' => 'Added',
    'externals/scripts/composer.js' => 'Improved RTL support',
    'externals/scripts/core.js' => 'Improved translation support; plurals are now supported fully as per Zend_Translate_Plural',
    'externals/styles/main.css' => 'Improved RTL support',
    'externals/styles/admin/main.css' => 'Style tweaks',
    'Form/Admin/Language/Create.php' => 'Fixed bug in translation of language names',
    'Form/Admin/Mail/Templates.php' => 'Added missing submit button; fixed bug in translation of language names',
    'Form/Admin/Settings/Locale.php' => 'Fixed bug in translation of language names',
    'Form/Admin/System/Log.php' => 'Other log files now show up',
    'Form/Admin/Tasks/Filter.php' => 'Added',
    'Form/Admin/Widget/Logo.php' => 'PHP 5.1 compat',
    'layouts/scripts/*' => 'Fixed SSL compatibility; improved translation support; upgraded mootools; mootools now uses minified version when in production mode',
    'Model/Ad.php' => 'Fixes improper search indexing',
    'Model/Adcampaign.php' => 'Fixes improper search indexing',
    'Model/Adphoto.php' => 'Fixes improper search indexing',
    'Model/GeoTag.php' => 'Fixes improper search indexing',
    'Model/ListItem.php' => 'Fixes improper search indexing',
    'Model/Page.php' => 'Fixes improper search indexing',
    'Model/Report.php' => 'Fixes improper search indexing',
    'Model/Style.php' => 'Fixes improper search indexing',
    'Model/TagMap.php' => 'Fixes improper search indexing',
    'Model/DbTable/Membership.php' => 'Performance tweak',
    'Model/DbTable/Tasks.php' => 'Added task types; fixed a bug with manual triggering; fixes bug in recovery after fatal errors; added set_time_limit(0)',
    'Plugin/Task/Abstract.php' => 'Added some methods',
    'Plugin/Task/PersistentAbstract.php' => 'Added',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.3p1-4.0.4.sql' => 'Added',
    'settings/my.sql' => 'Incremented version',
    'views/scripts/_FancyUpload.tpl' => 'Added missing translation',
    'views/scripts/admin-files/index.tpl' => 'Added missing translation',
    'views/scripts/admin-system/log.tpl' => 'Other log files now show up',
    'views/scripts/admin-tasks/index.tpl' => 'Improved',
    'views/scripts/utility/success.tpl' => 'Trying to fix IE javascript problem',
    'widgets/admin-menu-logo/index.tpl' => 'Fixed link in admin panel logo',
    'widgets/menu-mini/index.tpl' => 'Improved RTL support; changed notification pulldown update target',
    '/application/languages/en/core.csv' => 'Added missing phrases',
  ),
  '4.0.3' => array(
    'Api/Core.php' => 'hasSubject() accepts an argument to filter by',
    'Api/Links.php' => 'Fixes bad extensions in link thumbnails',
    'Api/Mail.php' => 'Added statistics; minor tweaks',
    'Api/Menus.php' => 'Added support for disabling menu items; added support for overriding plugin class methods',
    'Api/Search.php' => 'Added search filtering by item type',
    'Bootstrap.php' => 'Added missing translation',
    'controllers/AdminAdsController.php' => 'Fixed typo that caused problems in populating level and network selection',
    'controllers/AdminContentController.php' => 'Tweaks for improved widget form',
    'controllers/AdminIndexController.php' => 'Better handling of missing configuration files',
    'controllers/AdminLanguageController.php' => 'Added missing translation',
    'controllers/AdminMailController.php' => 'Added; split settings and templates into two actions; fixed template editing',
    'controllers/AdminMenusController.php' => 'Added support for disabling menu items; added missing translation',
    'controllers/AdminSettingsController.php' => 'Moved email settings, Cache setting failover',
    'controllers/AdminStatsController.php' => 'Added correct locale date format',
    'controllers/CommentController.php' => 'Comment can now be deleted by poster',
    'controllers/ErrorController.php' => 'Raw headers now use server protocol',
    'controllers/SearchController.php' => 'Added filtering of search results by content type; added search highlighting',
    'externals/scripts/core.js' => 'Fixed comment count updating during comment deletion',
    'externals/styles/admin/main.css' => 'Style tweaks',
    'Form/Search.php' => 'Added filtering of search results by content type',
    'Form/Admin/Mail/*' => 'Added',
    'Form/Admin/Menu/ItemCreate.php' => 'Added support for disabling menu items',
    'Form/Admin/Language/Create.php' => 'Added missing translation',
    'Form/Admin/Message/Mail.php' => 'Added missing translation',
    'Form/Admin/Settings/Locale.php' => 'Added missing translation',
    'Form/Admin/Settings/Performance.php' => 'Added missing translation',
    'Form/Admin/Widget/Ads.php' => 'Cleanup',
    'Form/Admin/Widget/Logo.php' => 'Cleanup',
    'Form/Admin/Widget/MenuGeneric.php' => 'Added generic menu widget',
    'Form/Admin/Widget/Standard.php' => 'Abstract widget admin edit form',
    'layouts/scripts/admin.tpl' => 'Fixed typo in timestamp language',
    'layouts/scripts/default.tpl' => 'Fixed typo in timestamp language',
    'settings/content.php' => 'Added generic menu widget',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.2-4.0.3.sql' => 'Added',
    'settings/my.sql' => 'Increased plugin column length; added support for disabling menu items; renamed some settings; split email settings into two items',
    'views/scripts/admin-content/index.tpl' => 'Added missing translation',
    'views/scripts/admin-files/index.tpl' => 'Added missing translation',
    'views/scripts/admin-language/index.tpl' => 'Added missing translation',
    'views/scripts/admin-mail/*' => 'Split email settings into two items',
    'views/scripts/admin-menus/index.tpl' => 'Added support for disabling menu items; added missing translation',
    'views/scripts/admin-system/php.tpl' => 'Added missing translation',
    'views/scripts/admin-themes/index.tpl' => 'Added missing translation',
    'views/scripts/comment/list.tpl' => 'Fixed bug in comment deletion',
    'views/scripts/search/index.tpl' => 'Added text highlighting',
    'widgets/menu-generic/*' => 'Added generic menu widget',
    'widgets/admin-menu-mini/Controller.php' => 'Better handling for missing configuration files',
    'widgets/admin-statistics/Controller.php' => 'Added email statistics',
    'widgets/container-tabs/index.tpl' => 'Fixed bug with more item when two are shown on a page',
    'widgets/content/index.tpl' => 'Fixes for embedding pages in content system',
    '/application/languages/en/core.csv' => 'Added phrases',
  ),
  '4.0.2' => array(
    'Api/Mail.php' => 'Added HTML support to system emails',
    'Api/Menus.php' => 'Added automatic class names to menu items',
    'Api/Ad.php' => 'Fixed bug in deleting ads without images',
    'controllers/AdminAdsController.php' => 'Added missing check for empty levels or networks; added delete selected',
    'controllers/AdminSettingsController.php' => 'Fix bug populating SMTP info into form',
    'controllers/AdminLanguageController.php' => 'Fix undefined offset bug',
    'controllers/CommentController.php' => 'Added missing delete comment option for object owner',
    'externals/scripts/core.js' => 'Added missing delete comment option for object owner',
    'externals/styles/admin/main.css' => 'Style tweak for nested dependent fields',
    'Form/Admin/Language/Upload.php' => 'Fix undefined offset bug',
    'Form/Admin/Widget/Logo.php' => 'Fixed problem that prevent uploading images with uppercase extensions',
    'settings/manifest.php' => 'Incremented version',
    'views/scripts/admin-ads/deleteselected.tpl' => 'Added delete selected',
    'views/scripts/admin-report/index.tpl' => 'Compatibility for reports imported from version 3',
    'views/scripts/comment/list.tpl' => 'Added missing delete comment option for object owner',
    'views/scripts/search/index.tpl' => 'Fix untranslated text',
    'wigets/admin-statistics/Controller.php' => 'Added statistic for online users',
  ),
  '4.0.1' => array(
    'Bootstrap.php' => 'Session cookie defaults to not httponly to solve FancyUpload problems',
    'Api/Ad.php' => 'Better cleanup of temporary files',
    'Api/Mail.php' => 'Enhanced queueing functionality',
    'controllers/AdminAuthController.php' => 'Added return url',
    'controllers/AdminFilesController.php' => 'Disallowed uploading of php files',
    'controllers/AdminMessageController.php' => 'Added email of all users',
    'controllers/AdminReportController.php' => 'Consistency',
    'controllers/AdminSettingsController.php' => 'Added configuration of mail transport',
    'controllers/ErrorController.php' => 'Added case in requireuser for facebook login',
    'Form/Report.php' => 'Added new report categories',
    'Form/Admin/Auth/Login.php' => 'Added return url',
    'Form/Admin/Language/Create.php' => 'Fix notice messages in creating language vars',
    'Form/Admin/Message/Mail.php' => 'Added email of all users',
    'Form/Admin/Settings/Email.php' => 'Added setting to enable/disable queueing',
    'Model/Adcampaign.php' => 'Adds checking for campaign start time',
    'Model/DbTable/Tasks.php' => 'Fixed possible bug in acquiring trigger lock',
    'Model/Item/Abstract.php' => 'Adjustments for trial and in cases of orphan items system handles missing owner more gracefully',
    'settings/manifest.php' => 'Incremented version',
    'settings/my-upgrade-4.0.0-4.0.1.sql' => 'Added',
    'settings/my.sql' => 'Removed comet settings; enhanced mail queue functionality; added menu item for email all members',
    'views/scripts/admin-content/index.tpl' => 'Fixed bug that prevented editing settings for widgets in a tabbed content block',
    'views/scripts/admin-language/edit.tpl' => 'Fixed problem with pagination',
    'views/scripts/admin-message/mail.tpl' => 'Added email of all users',
    'views/scripts/admin-settings/email.tpl' => 'Added configuration of mail transport',
    'views/scripts/admin-stats/referrers.tpl' => 'GET -> POST',
    'widgets/ad-campaign/Controller.php' => 'Adds checking for campaign start time',
  ),
) ?>