<?php
/**
*
* @ This file is created by deZender.Net
* @ deZender (PHP5 Decoder for ionCube Encoder)
*
* @	Version			:	2.0.0.3
* @	Author			:	DeZender
* @	Release on		:	06.05.2013
* @	Official site	:	http://DeZender.Net
*
*/


define("EmailNewLine", "\r\n");
define("EmailXMailer", "PHP-EMAIL,v2.0 (wmfwlr AT cogeco DOT ca)");
define("EmailDefaultCharset", "iso-8859-1");
define("EmailIsDebugging", false);


class email {


	public $To = null;
	public $Cc = null;
	public $Bcc = null;
	public $From = null;
	public $Subject = null;
	public $Versions = array();
	public $Attachments = array();
	public $Headers = null;
	public $RootContainer = null;

	public function email($to = null, $from = null, $subject = null, $headers = null, $mailserver_type = 0) {

		$this->To = strval($to);
		$this->From = strval($from);
		$this->Subject = strval($subject);
		$this->Headers = strval($headers);
		$this->RootContainer = new ContainerMimeBlock("multipart/mixed");
		if ($mailserver_type == 1)
		{
			define("EmailNewLine", "\n");
		}
		return;
	}

	public function settextcontent($content) {

		return $this->SetContent($content, "text/plain", "8bit");
	}

	public function sethtmlcontent($content) {

		return $this->SetContent($content, "text/html", "8bit");
	}

	public function setcontent($content, $mimeType = "text/plain", $encoding = "8bit") {

		$contentBlock = new LiteralMimeBlock($mimeType, $content, $encoding);
		return $this->AddContentBlock($contentBlock);
	}

	public function setfilecontent($pathToFile, $mimeType = null) {

		$fileVersion = new AttachmentMimeBlock($mimeType, $pathToFile);
		$fileVersion->IsAttachment = false;
		if (!($fileVersion->IsValid()))
		{
			return false;
		}
		$this->Versions[] = $fileVersion;
		return true;
	}

	public function addcontentblock($mimeBlock = null) {

		if (!$mimeBlock || !($mimeBlock->IsValid()))
		{
			return false;
		}
		$this->Versions[] = $mimeBlock;
		return true;
	}

	public function attach($pathToFile, $mimeType = null) {

		$attachment = new AttachmentMimeBlock($mimeType, $pathToFile);
		if (!($attachment->IsValid()))
		{
			return false;
		}
		$this->Attachments[] = $attachment;
		return true;
	}

	public function iscomplete() {

		return strlen(trim($this->To)) > 0 && strlen(trim($this->From)) > 0;
	}

	public function clear() {

		$this->RootContainer->Clear();
		$this->Versions = array();
		$this->Attachments = array();
		return;
	}

	public function send() {

		if (!($this->IsComplete()))
		{
			return false;
		}
		$headers = "Date: " . date("r", time()) . EmailNewLine . "From: " . strval($this->From) . EmailNewLine;
		if (strlen(trim(strval($this->Cc))) > 0)
		{
			$headers .= "CC: " . strval($this->Cc) . EmailNewLine;
		}
		if (strlen(trim(strval($this->Bcc))) > 0)
		{
			$headers .= "BCC: " . strval($this->Bcc) . EmailNewLine;
		}
		if ($this->Headers != null && strlen(trim($this->Headers)) > 0)
		{
			$headers .= $this->Headers . EmailNewLine;
		}
		$hasMultipleVersions = count($this->Versions) > 1;
		$hasOneVersion = count($this->Versions) == 1;
		$hasAttachments = count($this->Attachments) > 0;
		if ($hasMultipleVersions && $hasAttachments)
		{
			$this->RootContainer->ContentType = "multipart/mixed";
			$contentContainer = new ContainerMimeBlock("multipart/alternative");
			foreach ($this->Versions as $mimeVersion)
			{
				$contentContainer->Add($mimeVersion);
				continue;
			}
			$this->RootContainer->Add($contentContainer);
			foreach ($this->Attachments as $mimeFile)
			{
				$this->RootContainer->Add($mimeFile);
				continue;
			}
		}
		 else 
		{
			if ($hasMultipleVersions)
			{
				$this->RootContainer->ContentType = "multipart/alternative";
				foreach ($this->Versions as $mimeVersion)
				{
					$this->RootContainer->Add($mimeVersion);
					continue;
				}
			}
			 else 
			{
				if ($hasAttachments)
				{
					$this->RootContainer->ContentType = "multipart/mixed";
					if ($hasOneVersion)
					{
						$this->RootContainer->Add($this->Versions[0]);
					}
					foreach ($this->Attachments as $mimeFile)
					{
						$this->RootContainer->Add($mimeFile);
						continue;
					}
				}
				 else 
				{
					if ($hasOneVersion)
					{
						$this->RootContainer->ContentType = "multipart/mixed";
						$this->RootContainer->Add($this->Versions[0]);
					}
				}
			}
		}
		$headers .= "X-Mailer: " . EmailXMailer . EmailNewLine . "MIME-Version: 1.0" . EmailNewLine . "Content-Type: " . $this->RootContainer->ContentType . "; " . "boundary=\"" . $this->RootContainer->Boundary . "\"" . EmailNewLine . EmailNewLine;
		$thebody = $this->RootContainer->GetEncodedData();
		$this->RootContainer->Clear();
		if (EmailIsDebugging)
		{
			print "<b>&lt;email&gt;</b><br>";
			print str_replace(EmailNewLine, "&lt;newline&gt;<br>", $headers);
			print str_replace(EmailNewLine, "&lt;newline&gt;<br>", $thebody);
			print "<br><b>&lt;/email&gt;</b><br>";
		}
		if (strpos($this->From, "<") !== FALSE)
		{
			preg_match("/.* <(.*)>/iU", $this->From, $m);
			$env_sender = trim($m[1]);
		}
		 else 
		{
			$env_sender = $this->From;
		}
		if (!(mail($this->To, $this->Subject, $thebody, $headers, '' . "-f" . $env_sender)))
		{
			return mail($this->To, $this->Subject, $thebody, $headers);
		}
		return true;
	}

	public function isvalid($email) {

		$result = TRUE;
		if (!(eregi('' . "^[_a-z0-9-]+(\\.[_a-z0-9-]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*(\\.[a-z]{2,4})\$", $email)))
		{
			$result = FALSE;
		}
		return $result;
	}

};

class mimeblock {


	public $ContentType = null;
	public $Encoding = null;

	public function mimeblock($type, $encMethod = null) {

		$this->ContentType = strval($type);
		$this->Encoding = strval($encMethod);
		return;
	}

	public function isvalid() {

		return false;
	}

	public function hasencoding() {

		return strlen(trim($this->Encoding)) > 0;
	}

	public function getencodeddata() {

		return "";
	}

	public function getadditionalcontenttypeheader() {

		return "";
	}

	public function getcustomheaders() {

		return "";
	}

	public function tostring() {

		$text = "Content-Type: " . $this->ContentType . $this->GetAdditionalContentTypeHeader() . EmailNewLine;
		if ($this->HasEncoding())
		{
			$text .= "Content-Transfer-Encoding: " . $this->Encoding . EmailNewLine;
		}
		$text .= $this->GetCustomHeaders();
		$text .= EmailNewLine;
		$text .= $this->GetEncodedData();
		return $text;
	}

};

class literalmimeblock extends mimeblock {


	public $LiteralContent = null;
	public $Charset = EmailDefaultCharset;

	public function isvalid() {

		return strlen($this->LiteralContent) > 0;
	}

	public function getencodeddata() {

		return $this->LiteralContent;
	}

	public function getadditionalcontenttypeheader() {

		return "; charset=\"" . $this->Charset . "\"";
	}

	public function literalmimeblock($type, $content, $encMethod = null) {

		mimeblock::mimeblock($type, $encMethod);
		$this->LiteralContent = strval($content);
		return;
	}

};

class attachmentmimeblock extends mimeblock {


	public $FilePath = null;
	public $IsAttachment = true;

	public function isvalid() {

		return $this->Exists();
	}

	public function getencodeddata() {

		$fileData = "";
		if ($this->Exists())
		{
			$thefile = fopen($this->FilePath, "rb");
			$fileData = fread($thefile, filesize($this->FilePath));
			fclose($thefile);
		}
		$encData = chunk_split(base64_encode($fileData), 76, EmailNewLine);
		return substr($encData, 0, strlen($encData) - strlen(EmailNewLine));
	}

	public function getadditionalcontenttypeheader() {

		if ($this->IsAttachment)
		{
			return "; name=\"" . basename($this->FilePath) . "\"";
		}
		return "";
	}

	public function getcustomheaders() {

		if ($this->IsAttachment)
		{
			return "Content-Disposition: attachment; filename=\"" . basename($this->FilePath) . "\"" . EmailNewLine;
		}
		return "";
	}

	public function tostring() {

		if (strlen(trim($this->ContentType)) == 0)
		{
			$this->ContentType = "application/octet-stream";
		}
		return mimeblock::tostring();
	}

	public function attachmentmimeblock($type, $filePath) {

		mimeblock::mimeblock($type, "base64");
		$this->FilePath = strval($filePath);
		return;
	}

	public function exists() {

		if ($this->FilePath == null || strlen(trim($this->FilePath)) == 0)
		{
			return false;
		}
		return file_exists($this->FilePath);
	}

};

class containermimeblock extends mimeblock {


	public $Boundary = null;
	public $Blocks = array();

	public function isvalid() {

		return $this->Blocks != null && count($this->Blocks) > 0;
	}

	public function hasencoding() {

		return false;
	}

	public function getencodeddata() {

		$text = "";
		if (!($this->IsValid()))
		{
			return $text;
		}
		foreach ($this->Blocks as $mimeBlock)
		{
			$text .= "--" . $this->Boundary . EmailNewLine . $mimeBlock->ToString() . EmailNewLine . EmailNewLine;
			continue;
		}
		$text .= "--" . $this->Boundary . "--";
		return $text;
	}

	public function getadditionalcontenttypeheader() {

		return "; boundary=\"" . $this->Boundary . "\"";
	}

	public function containermimeblock($type) {

		mimeblock::mimeblock($type, "");
		$this->Boundary = "--" . md5(uniqid("mime_container"));
		return;
	}

	public function clear() {

		$this->Blocks = array();
		return;
	}

	public function add($mimeBlock = null) {

		if (!$mimeBlock || !($mimeBlock->IsValid()))
		{
			return false;
		}
		$this->Blocks[] = $mimeBlock;
		return true;
	}

};


?>
